/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.server;

import java.rmi.RemoteException;
import javax.jcr.Session;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.jackrabbit.rmi.remote.RemoteXASession;
import org.apache.jackrabbit.rmi.remote.SerializableXid;
import org.apache.jackrabbit.rmi.server.RemoteAdapterFactory;
import org.apache.jackrabbit.rmi.server.ServerSession;

public class ServerXASession
extends ServerSession
implements RemoteXASession {
    private final XAResource resource;

    public ServerXASession(Session session, XAResource resource, RemoteAdapterFactory factory) throws RemoteException {
        super(session, factory);
        this.resource = resource;
    }

    private static XAException getXAException(XAException e) {
        return new XAException(e.getMessage());
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            this.resource.commit(xid, onePhase);
        }
        catch (XAException e) {
            throw ServerXASession.getXAException(e);
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        try {
            this.resource.end(xid, flags);
        }
        catch (XAException e) {
            throw ServerXASession.getXAException(e);
        }
    }

    public void forget(Xid xid) throws XAException {
        try {
            this.resource.forget(xid);
        }
        catch (XAException e) {
            throw ServerXASession.getXAException(e);
        }
    }

    public int getTransactionTimeout() throws XAException {
        try {
            return this.resource.getTransactionTimeout();
        }
        catch (XAException e) {
            throw ServerXASession.getXAException(e);
        }
    }

    public int prepare(Xid xid) throws XAException {
        try {
            return this.resource.prepare(xid);
        }
        catch (XAException e) {
            throw ServerXASession.getXAException(e);
        }
    }

    public Xid[] recover(int flag) throws XAException {
        try {
            Xid[] xids = this.resource.recover(flag);
            for (int i = 0; i < xids.length; ++i) {
                xids[i] = new SerializableXid(xids[i]);
            }
            return xids;
        }
        catch (XAException e) {
            throw ServerXASession.getXAException(e);
        }
    }

    public void rollback(Xid xid) throws XAException {
        try {
            this.resource.rollback(xid);
        }
        catch (XAException e) {
            throw ServerXASession.getXAException(e);
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        try {
            return this.resource.setTransactionTimeout(seconds);
        }
        catch (XAException e) {
            throw ServerXASession.getXAException(e);
        }
    }

    public void start(Xid xid, int flags) throws XAException {
        try {
            this.resource.start(xid, flags);
        }
        catch (XAException e) {
            throw ServerXASession.getXAException(e);
        }
    }
}

