/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.server;

import java.rmi.RemoteException;
import javax.jcr.Item;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.rmi.remote.RemoteProperty;
import org.apache.jackrabbit.rmi.remote.RemotePropertyDefinition;
import org.apache.jackrabbit.rmi.server.RemoteAdapterFactory;
import org.apache.jackrabbit.rmi.server.ServerItem;
import org.apache.jackrabbit.rmi.value.SerialValueFactory;

public class ServerProperty
extends ServerItem
implements RemoteProperty {
    private Property property;

    public ServerProperty(Property property, RemoteAdapterFactory factory) throws RemoteException {
        super((Item)property, factory);
        this.property = property;
    }

    public Value getValue() throws RepositoryException, RemoteException {
        try {
            return SerialValueFactory.makeSerialValue(this.property.getValue());
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public Value[] getValues() throws RepositoryException, RemoteException {
        try {
            return this.getSerialValues(this.property.getValues());
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public void setValue(Value value) throws RepositoryException, RemoteException {
        try {
            this.property.setValue(value);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public void setValue(Value[] values) throws RepositoryException, RemoteException {
        try {
            this.property.setValue(values);
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public long getLength() throws RepositoryException, RemoteException {
        try {
            return this.property.getLength();
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public long[] getLengths() throws RepositoryException, RemoteException {
        try {
            return this.property.getLengths();
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public RemotePropertyDefinition getDefinition() throws RepositoryException, RemoteException {
        try {
            return this.getFactory().getRemotePropertyDefinition(this.property.getDefinition());
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }

    public int getType() throws RepositoryException, RemoteException {
        try {
            return this.property.getType();
        }
        catch (RepositoryException ex) {
            throw this.getRepositoryException(ex);
        }
    }
}

