/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.server.principal;

import java.rmi.RemoteException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.jackrabbit.rmi.remote.RemoteIterator;
import org.apache.jackrabbit.rmi.remote.principal.RemoteGroup;
import org.apache.jackrabbit.rmi.server.RemoteAdapterFactory;
import org.apache.jackrabbit.rmi.server.principal.ServerPrincipal;

public class ServerGroup
extends ServerPrincipal
implements RemoteGroup {
    public ServerGroup(Group principal, RemoteAdapterFactory factory) throws RemoteException {
        super((Principal)principal, factory);
    }

    public boolean isMember(String member) {
        return ServerGroup.isMember(member, (Group)this.getPrincipal());
    }

    public RemoteIterator members() throws RemoteException {
        Iterator<Principal> members = new Iterator<Principal>(){
            final Enumeration<? extends Principal> base;
            {
                this.base = ((Group)ServerGroup.this.getPrincipal()).members();
            }

            @Override
            public boolean hasNext() {
                return this.base.hasMoreElements();
            }

            @Override
            public Principal next() {
                return this.base.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
        return this.getFactory().getRemotePrincipalIterator(members);
    }

    private static boolean isMember(String memberName, Group group) {
        Enumeration pe = group.members();
        while (pe.hasMoreElements()) {
            Principal p = (Principal)pe.nextElement();
            if (memberName.equals(p.getName())) {
                return true;
            }
            if (!(p instanceof Group) || !ServerGroup.isMember(memberName, (Group)p)) continue;
            return true;
        }
        return false;
    }
}

