/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.server;

import java.rmi.RemoteException;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.rmi.remote.RemoteNodeDefinition;
import org.apache.jackrabbit.rmi.remote.RemoteNodeType;
import org.apache.jackrabbit.rmi.remote.RemotePropertyDefinition;
import org.apache.jackrabbit.rmi.server.RemoteAdapterFactory;
import org.apache.jackrabbit.rmi.server.ServerObject;

public class ServerNodeType
extends ServerObject
implements RemoteNodeType {
    private NodeType type;

    public ServerNodeType(NodeType type, RemoteAdapterFactory factory) throws RemoteException {
        super(factory);
        this.type = type;
    }

    private RemoteNodeDefinition[] getRemoteNodeDefArray(NodeDefinition[] defs) throws RemoteException {
        if (defs != null) {
            RemoteNodeDefinition[] remotes = new RemoteNodeDefinition[defs.length];
            for (int i = 0; i < defs.length; ++i) {
                remotes[i] = this.getFactory().getRemoteNodeDefinition(defs[i]);
            }
            return remotes;
        }
        return new RemoteNodeDefinition[0];
    }

    private RemotePropertyDefinition[] getRemotePropertyDefArray(PropertyDefinition[] defs) throws RemoteException {
        if (defs != null) {
            RemotePropertyDefinition[] remotes = new RemotePropertyDefinition[defs.length];
            for (int i = 0; i < defs.length; ++i) {
                remotes[i] = this.getFactory().getRemotePropertyDefinition(defs[i]);
            }
            return remotes;
        }
        return new RemotePropertyDefinition[0];
    }

    public String getName() throws RemoteException {
        return this.type.getName();
    }

    public boolean isMixin() throws RemoteException {
        return this.type.isMixin();
    }

    public boolean isAbstract() throws RemoteException {
        return this.type.isAbstract();
    }

    public boolean hasOrderableChildNodes() throws RemoteException {
        return this.type.hasOrderableChildNodes();
    }

    public RemoteNodeType[] getSupertypes() throws RemoteException {
        return this.getRemoteNodeTypeArray(this.type.getSupertypes());
    }

    public RemoteNodeType[] getDeclaredSupertypes() throws RemoteException {
        return this.getRemoteNodeTypeArray(this.type.getDeclaredSupertypes());
    }

    public boolean isNodeType(String type) throws RemoteException {
        return this.type.isNodeType(type);
    }

    public RemotePropertyDefinition[] getPropertyDefs() throws RemoteException {
        PropertyDefinition[] defs = this.type.getPropertyDefinitions();
        return this.getRemotePropertyDefArray(defs);
    }

    public RemotePropertyDefinition[] getDeclaredPropertyDefs() throws RemoteException {
        PropertyDefinition[] defs = this.type.getDeclaredPropertyDefinitions();
        return this.getRemotePropertyDefArray(defs);
    }

    public RemoteNodeDefinition[] getChildNodeDefs() throws RemoteException {
        return this.getRemoteNodeDefArray(this.type.getChildNodeDefinitions());
    }

    public RemoteNodeDefinition[] getDeclaredChildNodeDefs() throws RemoteException {
        return this.getRemoteNodeDefArray(this.type.getDeclaredChildNodeDefinitions());
    }

    public boolean canSetProperty(String name, Value value) throws RemoteException {
        return this.type.canSetProperty(name, value);
    }

    public boolean canSetProperty(String name, Value[] values) throws RemoteException {
        return this.type.canSetProperty(name, values);
    }

    public boolean canAddChildNode(String name) throws RemoteException {
        return this.type.canAddChildNode(name);
    }

    public boolean canAddChildNode(String name, String type) throws RemoteException {
        return this.type.canAddChildNode(name, type);
    }

    public boolean canRemoveItem(String name) throws RemoteException {
        return this.type.canRemoveItem(name);
    }

    public String getPrimaryItemName() throws RemoteException {
        return this.type.getPrimaryItemName();
    }
}

