/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.server.jcr;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.jcr.LoginException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.jackrabbit.server.SessionProvider;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavSession;
import org.apache.jackrabbit.webdav.DavSessionProvider;
import org.apache.jackrabbit.webdav.WebdavRequest;
import org.apache.jackrabbit.webdav.header.IfHeader;
import org.apache.jackrabbit.webdav.jcr.JcrDavException;
import org.apache.jackrabbit.webdav.jcr.JcrDavSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JCRWebdavServer
implements DavSessionProvider {
    private static Logger log = LoggerFactory.getLogger((Class)JCRWebdavServer.class);
    private final SessionCache cache = new SessionCache();
    private final Repository repository;
    private final SessionProvider sessionProvider;

    public JCRWebdavServer(Repository repository, SessionProvider sessionProvider) {
        this.repository = repository;
        this.sessionProvider = sessionProvider;
    }

    public boolean attachSession(WebdavRequest request) throws DavException {
        DavSession session = this.cache.get(request);
        request.setDavSession(session);
        return true;
    }

    public void releaseSession(WebdavRequest request) {
        DavSession session = request.getDavSession();
        if (session != null) {
            session.removeReference((Object)request);
        }
        request.setDavSession(null);
    }

    private static class SessionMap
    extends HashMap {
        private SessionMap() {
        }

        public HashSet get(DavSession key) {
            return (HashSet)super.get(key);
        }

        public HashSet put(DavSession key, HashSet value) {
            return super.put(key, value);
        }

        public HashSet remove(DavSession key) {
            return (HashSet)super.remove(key);
        }
    }

    private class SessionCache {
        private SessionMap sessionMap = new SessionMap();
        private HashMap referenceToSessionMap = new HashMap();

        private SessionCache() {
        }

        private DavSession get(WebdavRequest request) throws DavException {
            String txId = request.getTransactionId();
            String subscriptionId = request.getSubscriptionId();
            String lockToken = request.getLockToken();
            DavSession session = null;
            if (lockToken != null && this.containsReference(lockToken)) {
                session = this.getSessionByReference(lockToken);
            } else if (txId != null && this.containsReference(txId)) {
                session = this.getSessionByReference(txId);
            } else if (subscriptionId != null && this.containsReference(subscriptionId)) {
                session = this.getSessionByReference(subscriptionId);
            }
            if (session == null) {
                IfHeader ifHeader = new IfHeader((HttpServletRequest)request);
                Iterator it = ifHeader.getAllTokens();
                while (it.hasNext()) {
                    String token = it.next().toString();
                    if (!this.containsReference(token)) continue;
                    session = this.getSessionByReference(token);
                    break;
                }
            }
            if (session == null) {
                Session repSession = this.getRepositorySession(request);
                session = new DavSessionImpl(repSession);
                this.sessionMap.put(session, new HashSet());
                log.info("login: User '" + repSession.getUserID() + "' logged in.");
            } else {
                log.info("login: Retrieved cached session for user '" + this.getUserID(session) + "'");
            }
            this.addReference(session, request);
            return session;
        }

        private void addReference(DavSession session, Object reference) {
            HashSet referenceSet = this.sessionMap.get(session);
            if (referenceSet != null) {
                referenceSet.add(reference);
                this.referenceToSessionMap.put(reference, session);
            } else {
                log.error("Failed to add reference to session. No entry in cache found.");
            }
        }

        private void removeReference(DavSession session, Object reference) {
            HashSet referenceSet = this.sessionMap.get(session);
            if (referenceSet != null) {
                if (referenceSet.remove(reference)) {
                    log.info("Removed reference " + reference + " to session " + session);
                    this.referenceToSessionMap.remove(reference);
                } else {
                    log.warn("Failed to remove reference " + reference + " to session " + session);
                }
                if (referenceSet.isEmpty()) {
                    log.info("No more references present on webdav session -> clean up.");
                    this.sessionMap.remove(session);
                    try {
                        Session repSession = DavSessionImpl.getRepositorySession(session);
                        String usr = this.getUserID(session);
                        JCRWebdavServer.this.sessionProvider.releaseSession(repSession);
                        log.info("Login: User '" + usr + "' logged out");
                    }
                    catch (DavException e) {
                        log.error("Unexpected error: " + e.getMessage(), e.getCause());
                    }
                } else {
                    log.debug(referenceSet.size() + " references remaining on webdav session " + session);
                }
            } else {
                log.error("Failed to remove reference from session. No entry in cache found.");
            }
        }

        private boolean containsReference(Object reference) {
            return this.referenceToSessionMap.containsKey(reference);
        }

        private DavSession getSessionByReference(Object reference) {
            return (DavSession)this.referenceToSessionMap.get(reference);
        }

        private Session getRepositorySession(WebdavRequest request) throws DavException {
            try {
                String workspaceName = request.getRequestLocator().getWorkspaceName();
                return JCRWebdavServer.this.sessionProvider.getSession((HttpServletRequest)request, JCRWebdavServer.this.repository, workspaceName);
            }
            catch (LoginException e) {
                throw new JcrDavException((RepositoryException)((Object)e));
            }
            catch (RepositoryException e) {
                throw new JcrDavException(e);
            }
            catch (ServletException e) {
                throw new DavException(500);
            }
        }

        private String getUserID(DavSession session) {
            try {
                Session s = DavSessionImpl.getRepositorySession(session);
                if (s != null) {
                    return s.getUserID();
                }
            }
            catch (DavException e) {
                log.error(e.toString());
            }
            return session.toString();
        }
    }

    private class DavSessionImpl
    extends JcrDavSession {
        private DavSessionImpl(Session session) {
            super(session);
        }

        public void addReference(Object reference) {
            JCRWebdavServer.this.cache.addReference(this, reference);
        }

        public void removeReference(Object reference) {
            JCRWebdavServer.this.cache.removeReference(this, reference);
        }
    }
}

