/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.jcr;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Item;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavLocatorFactory;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.jcr.AbstractResource;
import org.apache.jackrabbit.webdav.jcr.DefaultItemCollection;
import org.apache.jackrabbit.webdav.jcr.JcrDavException;
import org.apache.jackrabbit.webdav.jcr.JcrDavSession;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.property.HrefProperty;
import org.apache.jackrabbit.webdav.version.LabelInfo;
import org.apache.jackrabbit.webdav.version.MergeInfo;
import org.apache.jackrabbit.webdav.version.UpdateInfo;
import org.apache.jackrabbit.webdav.version.VersionControlledResource;
import org.apache.jackrabbit.webdav.version.VersionHistoryResource;
import org.apache.jackrabbit.webdav.version.VersionResource;
import org.apache.jackrabbit.webdav.version.report.ReportType;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VersionControlledItemCollection
extends DefaultItemCollection
implements VersionControlledResource {
    private static Logger log = LoggerFactory.getLogger((Class)VersionControlledItemCollection.class);

    public VersionControlledItemCollection(DavResourceLocator locator, JcrDavSession session, DavResourceFactory factory, Item item) {
        super(locator, session, factory, item);
        if (this.exists() && !(item instanceof javax.jcr.Node)) {
            throw new IllegalArgumentException("A collection resource can not be constructed from a Property item.");
        }
    }

    public String getSupportedMethods() {
        StringBuffer sb = new StringBuffer(super.getSupportedMethods());
        sb.append(", ").append("VERSION-CONTROL");
        if (this.isVersionControlled()) {
            try {
                if (((javax.jcr.Node)this.item).isCheckedOut()) {
                    sb.append(", ").append("CHECKIN, MERGE");
                } else {
                    sb.append(", ").append("CHECKOUT, UPDATE, MERGE, LABEL");
                }
            }
            catch (RepositoryException e) {
                log.error(e.getMessage());
            }
        }
        return sb.toString();
    }

    public MultiStatusResponse alterProperties(List changeList) throws DavException {
        this.resolveMergeConflict(changeList);
        return super.alterProperties(changeList);
    }

    private void resolveMergeConflict(List changeList) throws DavException {
        if (!this.exists()) {
            throw new DavException(404);
        }
        try {
            javax.jcr.Node n = (javax.jcr.Node)this.item;
            DavProperty autoMergeSet = null;
            DavProperty predecessorSet = null;
            for (int i = 0; i < changeList.size(); ++i) {
                Object propEntry = changeList.get(i);
                if (propEntry instanceof DavPropertyName && AUTO_MERGE_SET.equals(propEntry)) {
                    if (!n.hasProperty("jcr:mergeFailed")) {
                        throw new DavException(409, "Attempt to resolve non-existing merge conflicts.");
                    }
                    Value[] mergeFailed = n.getProperty("jcr:mergeFailed").getValues();
                    for (int j = 0; j < mergeFailed.length; ++j) {
                        n.cancelMerge((Version)this.getRepositorySession().getNodeByUUID(mergeFailed[j].getString()));
                    }
                    changeList.remove(propEntry);
                    continue;
                }
                if (!(propEntry instanceof DavProperty)) continue;
                if (AUTO_MERGE_SET.equals((Object)((DavProperty)propEntry).getName())) {
                    autoMergeSet = (DavProperty)propEntry;
                    continue;
                }
                if (!PREDECESSOR_SET.equals((Object)((DavProperty)propEntry).getName())) continue;
                predecessorSet = (DavProperty)propEntry;
            }
            if (autoMergeSet != null) {
                if (!n.hasProperty("jcr:mergeFailed")) {
                    throw new DavException(409, "Attempt to resolve non-existing merge conflicts.");
                }
                List mergeset = new HrefProperty(autoMergeSet).getHrefs();
                ArrayList predecSet = predecessorSet == null ? new ArrayList() : new HrefProperty(predecessorSet).getHrefs();
                Session session = this.getRepositorySession();
                Value[] mergeFailed = n.getProperty("jcr:mergeFailed").getValues();
                for (int i = 0; i < mergeFailed.length; ++i) {
                    Version version = (Version)session.getNodeByUUID(mergeFailed[i].getString());
                    String href = this.getLocatorFromItem((Item)version).getHref(true);
                    if (mergeset.contains(href)) continue;
                    if (predecSet.contains(href)) {
                        n.doneMerge(version);
                        continue;
                    }
                    n.cancelMerge(version);
                }
                changeList.remove(autoMergeSet);
                if (predecessorSet != null) {
                    changeList.remove(predecessorSet);
                }
            }
        }
        catch (RepositoryException e) {
            throw new JcrDavException(e);
        }
    }

    public void addVersionControl() throws DavException {
        if (!this.exists()) {
            throw new DavException(404);
        }
        if (!this.isVersionControlled()) {
            try {
                ((javax.jcr.Node)this.item).addMixin("mix:versionable");
                this.item.save();
            }
            catch (RepositoryException e) {
                throw new JcrDavException(e);
            }
        }
    }

    public String checkin() throws DavException {
        if (!this.exists()) {
            throw new DavException(404);
        }
        if (!this.isVersionControlled()) {
            throw new DavException(405);
        }
        try {
            Version v = ((javax.jcr.Node)this.item).checkin();
            String versionHref = this.getLocatorFromItem((Item)v).getHref(true);
            return versionHref;
        }
        catch (RepositoryException e) {
            throw new JcrDavException(e);
        }
    }

    public void checkout() throws DavException {
        if (!this.exists()) {
            throw new DavException(404);
        }
        if (!this.isVersionControlled()) {
            throw new DavException(405);
        }
        try {
            ((javax.jcr.Node)this.item).checkout();
        }
        catch (RepositoryException e) {
            throw new JcrDavException(e);
        }
    }

    public void uncheckout() throws DavException {
        throw new DavException(501);
    }

    public MultiStatus update(UpdateInfo updateInfo) throws DavException {
        if (updateInfo == null) {
            throw new DavException(400, "Valid update request body required.");
        }
        if (!this.exists()) {
            throw new DavException(404);
        }
        MultiStatus ms = new MultiStatus();
        try {
            javax.jcr.Node node = (javax.jcr.Node)this.item;
            Element udElem = updateInfo.getUpdateElement();
            boolean removeExisting = DomUtil.hasChildElement((Node)udElem, (String)"removeexisting", (Namespace)NAMESPACE);
            AbstractResource.EListener el = new AbstractResource.EListener(this, updateInfo.getPropertyNameSet(), ms);
            this.registerEventListener(el, node.getPath());
            if (updateInfo.getVersionHref() != null) {
                String[] hrefs = updateInfo.getVersionHref();
                if (hrefs.length != 1) {
                    throw new DavException(400, "Invalid update request body missing version href or containing multiple version hrefs.");
                }
                String versionPath = this.getLocatorFromHref(hrefs[0]).getRepositoryPath();
                String versionName = VersionControlledItemCollection.getItemName(versionPath);
                String relPath = DomUtil.getChildText((Element)udElem, (String)"relpath", (Namespace)NAMESPACE);
                if (relPath == null) {
                    node.restore(versionName, removeExisting);
                } else {
                    Version v = node.getVersionHistory().getVersion(versionName);
                    node.restore(v, relPath, removeExisting);
                }
            } else if (updateInfo.getLabelName() != null) {
                String[] labels = updateInfo.getLabelName();
                if (labels.length != 1) {
                    throw new DavException(400, "Invalid update request body: Multiple labels specified.");
                }
                node.restoreByLabel(labels[0], removeExisting);
            } else if (updateInfo.getWorkspaceHref() != null) {
                String workspaceName = this.getLocatorFromHref(updateInfo.getWorkspaceHref()).getWorkspaceName();
                node.update(workspaceName);
            } else {
                throw new DavException(400, "Invalid update request body.");
            }
            this.unregisterEventListener(el);
        }
        catch (RepositoryException e) {
            throw new JcrDavException(e);
        }
        return ms;
    }

    public MultiStatus merge(MergeInfo mergeInfo) throws DavException {
        if (mergeInfo == null) {
            throw new DavException(400);
        }
        if (!this.exists()) {
            throw new DavException(404);
        }
        MultiStatus ms = new MultiStatus();
        try {
            javax.jcr.Node node = (javax.jcr.Node)this.item;
            AbstractResource.EListener el = new AbstractResource.EListener(this, mergeInfo.getPropertyNameSet(), ms);
            this.registerEventListener(el, node.getPath());
            String workspaceName = this.getLocatorFromHref(mergeInfo.getSourceHrefs()[0]).getWorkspaceName();
            NodeIterator failed = node.merge(workspaceName, !mergeInfo.isNoAutoMerge());
            this.unregisterEventListener(el);
            while (failed.hasNext()) {
                javax.jcr.Node failedNode = failed.nextNode();
                DavResourceLocator loc = this.getLocatorFromItem((Item)failedNode);
                DavResource res = this.createResourceFromLocator(loc);
                ms.addResponse(new MultiStatusResponse(res, mergeInfo.getPropertyNameSet()));
            }
        }
        catch (RepositoryException e) {
            throw new JcrDavException(e);
        }
        return ms;
    }

    public void label(LabelInfo labelInfo) throws DavException {
        if (labelInfo == null) {
            throw new DavException(400, "Valid label request body required.");
        }
        if (!this.exists()) {
            throw new DavException(404);
        }
        try {
            if (!this.isVersionControlled() || ((javax.jcr.Node)this.item).isCheckedOut()) {
                throw new DavException(412, "A LABEL request may only be applied to a version-controlled, checked-in resource.");
            }
            DavResource[] resArr = this.getReferenceResources(CHECKED_IN);
            if (resArr.length != 1 || !(resArr[0] instanceof VersionResource)) {
                throw new DavException(500, "DAV:checked-in property on '" + this.getHref() + "' did not point to a single VersionResource.");
            }
            ((VersionResource)resArr[0]).label(labelInfo);
        }
        catch (RepositoryException e) {
            throw new JcrDavException(e);
        }
    }

    public VersionHistoryResource getVersionHistory() throws DavException {
        if (!this.exists()) {
            throw new DavException(404);
        }
        try {
            VersionHistory vh = ((javax.jcr.Node)this.item).getVersionHistory();
            DavResourceLocator loc = this.getLocatorFromItem((Item)vh);
            return (VersionHistoryResource)this.createResourceFromLocator(loc);
        }
        catch (RepositoryException e) {
            throw new JcrDavException(e);
        }
    }

    protected void initSupportedReports() {
        super.initSupportedReports();
        if (this.exists()) {
            this.supportedReports.addReportType(ReportType.LOCATE_BY_HISTORY);
            if (this.isVersionControlled()) {
                this.supportedReports.addReportType(ReportType.VERSION_TREE);
            }
        }
    }

    protected void initProperties() {
        super.initProperties();
        if (this.exists()) {
            javax.jcr.Node n = (javax.jcr.Node)this.item;
            if (this.isVersionControlled()) {
                try {
                    String vhHref = this.getLocatorFromItem((Item)n.getVersionHistory()).getHref(true);
                    this.properties.add((DavProperty)new HrefProperty(VERSION_HISTORY, vhHref, true));
                    this.properties.add((DavProperty)new DefaultDavProperty(AUTO_VERSION, null, false));
                    String baseVHref = this.getLocatorFromItem((Item)n.getBaseVersion()).getHref(true);
                    if (n.isCheckedOut()) {
                        this.properties.add((DavProperty)new HrefProperty(CHECKED_OUT, baseVHref, true));
                        if (n.hasProperty("jcr:predecessors")) {
                            Value[] predec = n.getProperty("jcr:predecessors").getValues();
                            this.addHrefProperty(PREDECESSOR_SET, predec, false);
                        }
                        if (n.hasProperty("jcr:mergeFailed")) {
                            Value[] mergeFailed = n.getProperty("jcr:mergeFailed").getValues();
                            this.addHrefProperty(AUTO_MERGE_SET, mergeFailed, false);
                        }
                    } else {
                        this.properties.add((DavProperty)new HrefProperty(CHECKED_IN, baseVHref, true));
                    }
                }
                catch (RepositoryException e) {
                    log.error(e.getMessage());
                }
            }
        }
    }

    private void addHrefProperty(DavPropertyName name, Value[] values, boolean isProtected) throws ValueFormatException, IllegalStateException, RepositoryException {
        javax.jcr.Node[] nodes = new javax.jcr.Node[values.length];
        for (int i = 0; i < values.length; ++i) {
            nodes[i] = this.getRepositorySession().getNodeByUUID(values[i].getString());
        }
        this.addHrefProperty(name, (Item[])nodes, isProtected);
    }

    private boolean isVersionControlled() {
        boolean vc = false;
        if (this.exists()) {
            try {
                vc = ((javax.jcr.Node)this.item).isNodeType("mix:versionable");
            }
            catch (RepositoryException e) {
                log.warn(e.getMessage());
            }
        }
        return vc;
    }

    private DavResourceLocator getLocatorFromHref(String href) {
        DavLocatorFactory f = this.getLocator().getFactory();
        String prefix = this.getLocator().getPrefix();
        return f.createResourceLocator(prefix, href);
    }
}

