/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.jcr.version.report;

import javax.jcr.Repository;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.jcr.ItemResourceConstants;
import org.apache.jackrabbit.webdav.jcr.version.report.AbstractJcrReport;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.jackrabbit.webdav.version.report.ReportType;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RepositoryDescriptorsReport
extends AbstractJcrReport
implements ItemResourceConstants {
    private static Logger log = LoggerFactory.getLogger((Class)RepositoryDescriptorsReport.class);
    public static final ReportType REPOSITORY_DESCRIPTORS_REPORT = ReportType.register((String)"repositorydescriptors", (Namespace)ItemResourceConstants.NAMESPACE, (Class)RepositoryDescriptorsReport.class);

    public ReportType getType() {
        return REPOSITORY_DESCRIPTORS_REPORT;
    }

    public boolean isMultiStatusReport() {
        return false;
    }

    public void init(DavResource resource, ReportInfo info) throws DavException {
        super.init(resource, info);
    }

    public Element toXml(Document document) {
        Repository repository = this.getRepositorySession().getRepository();
        Element report = DomUtil.createElement((Document)document, (String)"repositorydescriptors-report", (Namespace)NAMESPACE);
        String[] keys = repository.getDescriptorKeys();
        for (int i = 0; i < keys.length; ++i) {
            Element elem = DomUtil.addChildElement((Element)report, (String)"descriptor", (Namespace)NAMESPACE);
            DomUtil.addChildElement((Element)elem, (String)"descriptorkey", (Namespace)NAMESPACE, (String)keys[i]);
            DomUtil.addChildElement((Element)elem, (String)"descriptorvalue", (Namespace)NAMESPACE, (String)repository.getDescriptor(keys[i]));
        }
        return report;
    }
}

