/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.simple;

import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavMethods;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.DavServletRequest;
import org.apache.jackrabbit.webdav.DavServletResponse;
import org.apache.jackrabbit.webdav.DavSession;
import org.apache.jackrabbit.webdav.lock.LockManager;
import org.apache.jackrabbit.webdav.simple.DavResourceImpl;
import org.apache.jackrabbit.webdav.simple.ResourceConfig;

public class ResourceFactoryImpl
implements DavResourceFactory {
    private final LockManager lockMgr;
    private final ResourceConfig resourceConfig;

    public ResourceFactoryImpl(LockManager lockMgr) {
        this.lockMgr = lockMgr;
        this.resourceConfig = new ResourceConfig();
    }

    public ResourceFactoryImpl(LockManager lockMgr, ResourceConfig resourceConfig) {
        this.lockMgr = lockMgr;
        this.resourceConfig = resourceConfig != null ? resourceConfig : new ResourceConfig();
    }

    public DavResource createResource(DavResourceLocator locator, DavServletRequest request, DavServletResponse response) throws DavException {
        DavResourceImpl resource = (DavResourceImpl)this.createResource(locator, request.getDavSession());
        if (DavMethods.isCreateRequest((DavServletRequest)request) && !resource.exists()) {
            resource.setIsCollection(DavMethods.isCreateCollectionRequest((DavServletRequest)request));
        }
        return resource;
    }

    public DavResource createResource(DavResourceLocator locator, DavSession session) throws DavException {
        DavResourceImpl res = new DavResourceImpl(locator, this, session, this.resourceConfig);
        res.addLockManager(this.lockMgr);
        return res;
    }
}

