/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.server.remoting.davex;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.server.remoting.davex.ProtectedItemRemoveHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtectedRemoveManager {
    private static final Logger log = LoggerFactory.getLogger(ProtectedRemoveManager.class);
    private List<ProtectedItemRemoveHandler> handlers = new ArrayList<ProtectedItemRemoveHandler>();

    public ProtectedRemoveManager(String config) throws IOException {
        if (config == null) {
            log.warn("protectedhandlers-config is missing -> DIFF processing can fail for the Remove operation if the content toremove is protected!");
        } else {
            File file = new File(config);
            if (file.exists()) {
                FileInputStream inStream = new FileInputStream(file);
                Properties props = new Properties();
                props.load(inStream);
                Enumeration<?> en = props.propertyNames();
                while (en.hasMoreElements()) {
                    ProtectedItemRemoveHandler irHandler;
                    String key = en.nextElement().toString();
                    String className = props.getProperty(key);
                    if (className.isEmpty() || (irHandler = ProtectedRemoveManager.createHandler(className)) == null) continue;
                    this.handlers.add(irHandler);
                }
            } else if (!config.isEmpty()) {
                ProtectedItemRemoveHandler irHandler = ProtectedRemoveManager.createHandler(config);
                if (irHandler != null) {
                    this.handlers.add(irHandler);
                }
            } else {
                log.debug("Fail to locate the protected-item-remove-handler properties file.");
            }
        }
    }

    public boolean remove(Session session, String itemPath) throws RepositoryException {
        for (ProtectedItemRemoveHandler handler : this.handlers) {
            if (!handler.remove(session, itemPath)) continue;
            return true;
        }
        return false;
    }

    private static ProtectedItemRemoveHandler createHandler(String className) {
        try {
            Class<?> irHandlerClass = Class.forName(className);
            if (ProtectedItemRemoveHandler.class.isAssignableFrom(irHandlerClass)) {
                ProtectedItemRemoveHandler irHandler = (ProtectedItemRemoveHandler)irHandlerClass.newInstance();
                return irHandler;
            }
        }
        catch (ClassNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }
}

