/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.servlet.remote;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.jackrabbit.rmi.client.LocalAdapterFactory;
import org.apache.jackrabbit.rmi.remote.RemoteRepository;
import org.apache.jackrabbit.rmi.repository.JNDIRemoteRepositoryFactory;
import org.apache.jackrabbit.servlet.remote.RemoteRepositoryServlet;

public class JNDIRemoteRepositoryServlet
extends RemoteRepositoryServlet {
    private static final long serialVersionUID = 9029928193416404478L;

    protected Repository getRepository() throws RepositoryException {
        String location = "//localhost/" + RemoteRepository.class.getName().replace('.', '/');
        try {
            Hashtable<String, String> environment = new Hashtable<String, String>();
            Enumeration names = this.getInitParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if (name.equals("location")) {
                    location = this.getInitParameter(name);
                    continue;
                }
                if (name.equals(Repository.class.getName()) || name.equals(LocalAdapterFactory.class.getName())) continue;
                environment.put(name, this.getInitParameter(name));
            }
            return new JNDIRemoteRepositoryFactory(this.getLocalAdapterFactory(), (Context)new InitialContext(environment), location).getRepository();
        }
        catch (NamingException e) {
            throw new RepositoryException("Repository not found: Invalid JNDI context", (Throwable)e);
        }
    }
}

