/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.test.AbstractJCRTest;

public class SetValueBooleanTest
extends AbstractJCRTest {
    private Value value;
    private Node node;
    private Property property1;

    protected void setUp() throws Exception {
        super.setUp();
        this.value = this.superuser.getValueFactory().createValue(true);
        this.node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.property1 = this.node.setProperty(this.propertyName1, false);
        this.superuser.save();
    }

    protected void tearDown() throws Exception {
        this.value = null;
        this.node = null;
        this.property1 = null;
        super.tearDown();
    }

    public void testBooleanSession() throws RepositoryException {
        this.property1.setValue(this.value);
        this.superuser.save();
        SetValueBooleanTest.assertEquals((String)"Boolean property not saved", (boolean)this.value.getBoolean(), (boolean)this.property1.getValue().getBoolean());
    }

    public void testBooleanParent() throws RepositoryException {
        this.property1.setValue(this.value.getBoolean());
        this.node.save();
        SetValueBooleanTest.assertEquals((String)"Boolean property not saved", (boolean)this.value.getBoolean(), (boolean)this.property1.getValue().getBoolean());
    }

    public void testRemoveBooleanSession() throws RepositoryException {
        this.property1.setValue((Value)null);
        this.superuser.save();
        try {
            this.node.getProperty(this.propertyName1);
            SetValueBooleanTest.fail((String)"The property should not exist anymore, as a null Value has been assigned");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testRemoveBooleanParent() throws RepositoryException {
        this.property1.setValue((Value)null);
        this.node.save();
        try {
            this.node.getProperty(this.propertyName1);
            SetValueBooleanTest.fail((String)"The property should not exist anymore, as a null Value has been assigned");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }
}

