/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.nodetype;

import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;

public class NodeTypeTest
extends AbstractJCRTest {
    private Session session;
    private NodeTypeManager manager;
    private Node rootNode;

    protected void setUp() throws Exception {
        this.isReadOnly = true;
        super.setUp();
        this.session = helper.getReadOnlySession();
        this.manager = this.session.getWorkspace().getNodeTypeManager();
        this.rootNode = this.session.getRootNode();
    }

    protected void tearDown() throws Exception {
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        this.manager = null;
        this.rootNode = null;
        super.tearDown();
    }

    public void testGetName() throws RepositoryException {
        NodeType type = this.manager.getNodeType(this.ntBase);
        NodeTypeTest.assertEquals((String)"getName() must return the name of the node", (String)this.ntBase, (String)type.getName());
    }

    public void testIsMixin() throws RepositoryException {
        NodeTypeIterator primaryTypes = this.manager.getPrimaryNodeTypes();
        NodeTypeTest.assertFalse((String)"testIsMixin() must return false if applied on a primary node type", (boolean)primaryTypes.nextNodeType().isMixin());
        NodeTypeIterator mixinTypes = this.manager.getMixinNodeTypes();
        if (this.getSize((RangeIterator)mixinTypes) > 0L) {
            mixinTypes = this.manager.getMixinNodeTypes();
            NodeTypeTest.assertTrue((String)"testIsMixin() must return true if applied on a mixin node type", (boolean)mixinTypes.nextNodeType().isMixin());
        }
    }

    public void testGetPrimaryItemName() throws NotExecutableException, RepositoryException {
        Node node = this.locateNodeWithPrimaryItem(this.rootNode);
        if (node == null) {
            throw new NotExecutableException("Workspace does not contain a node with primary item defined");
        }
        String name = node.getPrimaryItem().getName();
        NodeType type = node.getPrimaryNodeType();
        NodeTypeTest.assertEquals((String)"node.getPrimaryNodeType().getPrimaryItemName() must return the same name as node.getPrimaryItem().getName()", (String)name, (String)type.getPrimaryItemName());
    }

    public void testGetPrimaryItemNameNotExisting() throws NotExecutableException, RepositoryException {
        Node node = this.locateNodeWithoutPrimaryItem(this.rootNode);
        if (node == null) {
            throw new NotExecutableException("Workspace does not contain a node without primary item defined");
        }
        NodeType type = node.getPrimaryNodeType();
        NodeTypeTest.assertNull((String)"getPrimaryItemName() must return null if NodeType does not define a primary item", (Object)type.getPrimaryItemName());
    }

    public void testGetSupertypes() throws NotExecutableException, RepositoryException {
        NodeTypeIterator types = this.manager.getPrimaryNodeTypes();
        NodeType type = null;
        while (types.hasNext() && (type = types.nextNodeType()).getName().equals(this.ntBase)) {
        }
        if (type.getName().equals("nt:base")) {
            throw new NotExecutableException("Workspace does not have sufficient primary node types to run this test. At least nt:base plus anther type are required.");
        }
        NodeType[] supertypes = type.getSupertypes();
        boolean hasNTBase = false;
        for (int i = 0; i < supertypes.length; ++i) {
            if (!supertypes[i].getName().equals(this.ntBase)) continue;
            hasNTBase = true;
            break;
        }
        NodeTypeTest.assertTrue((String)"getSupertypes() of a primary node type that is not \"nt:base\" must at least return \"nt:base\"", (boolean)hasNTBase);
    }

    public void testGetDeclaredSupertypes() throws RepositoryException {
        NodeTypeIterator types = this.manager.getAllNodeTypes();
        while (types.hasNext()) {
            NodeType type = types.nextNodeType();
            NodeType[] declaredSupertypes = type.getDeclaredSupertypes();
            NodeType[] supertypes = type.getSupertypes();
            try {
                for (int i = 0; i < declaredSupertypes.length; ++i) {
                    boolean exists = false;
                    for (int j = 0; j < supertypes.length; ++j) {
                        if (!supertypes[j].getName().equals(declaredSupertypes[i].getName())) continue;
                        exists = true;
                        break;
                    }
                    NodeTypeTest.assertTrue((String)"All node types returned by getDeclaredSupertypes() must also be returned by getSupertypes()", (boolean)exists);
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                NodeTypeTest.fail((String)"The array returned by getDeclaredSupertypes() must not exceed the one returned by getSupertypes()");
            }
        }
    }

    public void testIsNodeType() throws RepositoryException {
        NodeTypeIterator types = this.manager.getPrimaryNodeTypes();
        while (types.hasNext()) {
            NodeType type = types.nextNodeType();
            NodeTypeTest.assertTrue((String)"isNodeType(String nodeTypeName) must return true if NodeType is nodeTypeName", (boolean)type.isNodeType(type.getName()));
            if (type.isMixin()) {
                NodeTypeTest.assertFalse((String)"isNodeType(String nodeTypeName) must return false if NodeType is not a subtype of nodeTypeName", (boolean)type.isNodeType(this.ntBase));
                continue;
            }
            NodeTypeTest.assertTrue((String)"isNodeType(String nodeTypeName) must return true if NodeType is a subtype of nodeTypeName", (boolean)type.isNodeType(this.ntBase));
        }
    }

    public void testGetDeclaredPropertyDefs() throws RepositoryException {
        NodeTypeIterator types = this.manager.getAllNodeTypes();
        while (types.hasNext()) {
            NodeType type = types.nextNodeType();
            PropertyDefinition[] declaredDefs = type.getDeclaredPropertyDefinitions();
            PropertyDefinition[] defs = type.getPropertyDefinitions();
            try {
                for (int i = 0; i < declaredDefs.length; ++i) {
                    boolean exists = false;
                    for (int j = 0; j < defs.length; ++j) {
                        if (!defs[j].getName().equals(declaredDefs[i].getName())) continue;
                        exists = true;
                        break;
                    }
                    NodeTypeTest.assertTrue((String)"All property defs returned by getDeclaredPropertyDefs() must also be returned by getPropertyDefs()", (boolean)exists);
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                NodeTypeTest.fail((String)"The array returned by getDeclaredPropertyDefs() must not exceed the one returned by getPropertyDefs()");
            }
        }
    }

    public void testGetPropertyDefs() throws NotExecutableException, RepositoryException {
        NodeTypeIterator types = this.manager.getPrimaryNodeTypes();
        while (types.hasNext()) {
            NodeType type = types.nextNodeType();
            PropertyDefinition[] defs = type.getPropertyDefinitions();
            boolean hasJCRPrimaryType = false;
            for (int i = 0; i < defs.length; ++i) {
                if (!defs[i].getName().equals(this.jcrPrimaryType)) continue;
                hasJCRPrimaryType = true;
                break;
            }
            NodeTypeTest.assertTrue((String)"getPropertyDefs() of a primary node type must return also \"jcr:primaryType\".", (boolean)hasJCRPrimaryType);
        }
    }

    public void testGetDeclaredChildNodeDefs() throws RepositoryException {
        NodeTypeIterator types = this.manager.getAllNodeTypes();
        while (types.hasNext()) {
            NodeType type = types.nextNodeType();
            NodeDefinition[] declaredDefs = type.getDeclaredChildNodeDefinitions();
            NodeDefinition[] defs = type.getChildNodeDefinitions();
            try {
                for (int i = 0; i < declaredDefs.length; ++i) {
                    boolean exists = false;
                    for (int j = 0; j < defs.length; ++j) {
                        if (!defs[j].getName().equals(declaredDefs[i].getName())) continue;
                        exists = true;
                        break;
                    }
                    NodeTypeTest.assertTrue((String)"All node defs returned by getDeclaredChildNodeDefs() must also be returned by getChildNodeDefs().", (boolean)exists);
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                NodeTypeTest.fail((String)"The array returned by getDeclaredChildNodeDefs() must not exceed the one returned by getChildNodeDefs()");
            }
        }
    }

    private Node locateNodeWithPrimaryItem(Node node) throws RepositoryException {
        try {
            node.getPrimaryItem();
            return node;
        }
        catch (ItemNotFoundException e) {
            NodeIterator nodes = node.getNodes();
            while (nodes.hasNext()) {
                Node returnedNode = this.locateNodeWithPrimaryItem(nodes.nextNode());
                if (returnedNode == null) continue;
                return returnedNode;
            }
            return null;
        }
    }

    private Node locateNodeWithoutPrimaryItem(Node node) throws RepositoryException {
        try {
            node.getPrimaryItem();
        }
        catch (ItemNotFoundException e) {
            return node;
        }
        NodeIterator nodes = node.getNodes();
        while (nodes.hasNext()) {
            Node returnedNode = this.locateNodeWithoutPrimaryItem(nodes.nextNode());
            if (returnedNode == null) continue;
            return returnedNode;
        }
        return null;
    }
}

