/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.version;

import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import org.apache.jackrabbit.test.api.version.AbstractVersionTest;

public class CheckoutTest
extends AbstractVersionTest {
    protected void setUp() throws Exception {
        super.setUp();
        if (!this.versionableNode.isCheckedOut()) {
            CheckoutTest.fail((String)"A versionable node must be checked-out after persistent creation.");
        }
        this.versionableNode.checkin();
    }

    public void testIsCheckedOut() throws RepositoryException {
        this.versionableNode.checkout();
        CheckoutTest.assertTrue((String)"After calling Node.checkout() a versionable node N, N.isCheckedOut() must return true.", (boolean)this.versionableNode.isCheckedOut());
    }

    public void testIsCheckedOutNonVersionableNode() throws RepositoryException {
        boolean isCheckedOut = this.nonVersionableNode.isCheckedOut();
        Node vParent = null;
        try {
            vParent = this.nonVersionableNode.getParent();
            while (!vParent.isNodeType(this.mixVersionable)) {
                vParent = vParent.getParent();
            }
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
        if (vParent != null && vParent.isNodeType(this.mixVersionable)) {
            if (vParent.isCheckedOut()) {
                CheckoutTest.assertTrue((String)"Node.isCheckedOut() must return true if the node is non-versionable and its nearest versionable ancestor is checked-out.", (boolean)isCheckedOut);
            } else {
                CheckoutTest.assertFalse((String)"Node.isCheckedOut() must return false if the node is non-versionable and its nearest versionable ancestor is checked-in.", (boolean)isCheckedOut);
            }
        } else {
            CheckoutTest.assertTrue((String)"Node.isCheckedOut() must return true if the node is non-versionable and has no versionable ancestor", (boolean)isCheckedOut);
        }
    }

    public void testCheckoutNonVersionableNode() throws RepositoryException {
        try {
            this.nonVersionableNode.checkout();
            CheckoutTest.fail((String)"Node.checkout() on a non versionable node must throw UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testCheckoutTwiceDoesNotThrow() throws RepositoryException {
        this.versionableNode.checkout();
        this.versionableNode.checkout();
    }

    public void testCheckoutCopiesBaseValueToPredecessorProperty() throws RepositoryException {
        Value baseVersionValue = this.versionableNode.getProperty(this.jcrBaseVersion).getValue();
        this.versionableNode.checkout();
        Value[] predecessorsValues = this.versionableNode.getProperty(this.jcrPredecessors).getValues();
        boolean foundBaseVersionProp = false;
        for (int i = 0; i < predecessorsValues.length && !foundBaseVersionProp; ++i) {
            if (!predecessorsValues[i].equals(baseVersionValue)) continue;
            foundBaseVersionProp = true;
        }
        if (!foundBaseVersionProp) {
            CheckoutTest.fail((String)"After calling Node.checkout() the current value of node's jcr:baseVersion must be copied to node's jcr:predecessors property");
        }
    }
}

