/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.version;

import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionIterator;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.version.AbstractVersionTest;

public class RestoreTest
extends AbstractVersionTest {
    Version version;
    Version version2;
    Version rootVersion;
    Node versionableNode2;

    protected void setUp() throws Exception {
        super.setUp();
        this.version = this.versionableNode.checkin();
        this.versionableNode.checkout();
        this.version2 = this.versionableNode.checkin();
        this.versionableNode.checkout();
        this.rootVersion = this.versionableNode.getVersionHistory().getRootVersion();
        try {
            this.versionableNode2 = this.createVersionableNode(this.testRootNode, this.nodeName2, this.versionableNodeType);
        }
        catch (RepositoryException e) {
            RestoreTest.fail((String)("Failed to create a second versionable node: " + e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDown() throws Exception {
        try {
            this.versionableNode2.remove();
            this.testRootNode.save();
        }
        finally {
            this.version = null;
            this.version2 = null;
            this.rootVersion = null;
            this.versionableNode2 = null;
            super.tearDown();
        }
    }

    public void testRestoreRootVersionFail() throws RepositoryException {
        try {
            this.versionableNode.restore(this.rootVersion, true);
            RestoreTest.fail((String)"Restore of jcr:rootVersion must throw VersionException.");
        }
        catch (VersionException versionException) {
            // empty catch block
        }
    }

    public void testRestoreOnCheckedInNode() throws RepositoryException {
        this.versionableNode.checkin();
        this.versionableNode.restore(this.version, true);
    }

    public void testRestoreOnCheckedOutNode() throws RepositoryException {
        this.versionableNode.restore(this.version, true);
    }

    public void testRestoreSetsIsCheckedOutToFalse() throws RepositoryException {
        this.versionableNode.restore(this.version, true);
        RestoreTest.assertFalse((String)"Restoring a node sets the jcr:isCheckedOut property to false", (boolean)this.versionableNode.isCheckedOut());
    }

    public void testRestoreSetsBaseVersion() throws RepositoryException {
        this.versionableNode.restore(this.version, true);
        Version baseV = this.versionableNode.getBaseVersion();
        RestoreTest.assertTrue((String)"Restoring a node must set node's base version in order to point to the restored version.", (boolean)this.version.isSame((Item)baseV));
    }

    public void testRestoreWithPendingChanges() throws RepositoryException {
        try {
            this.versionableNode.setProperty(this.propertyName1, this.propertyValue);
            this.versionableNode.restore(this.version, true);
            RestoreTest.fail((String)"InvalidItemStateException must be thrown on attempt to restore a node having any unsaved changes pending.");
        }
        catch (InvalidItemStateException invalidItemStateException) {
            // empty catch block
        }
    }

    public void testRestoreInvalidVersion() throws RepositoryException {
        Version vNode2 = this.versionableNode2.checkin();
        try {
            this.versionableNode.restore(vNode2, true);
            RestoreTest.fail((String)"VersionException expected on Node.restore(Version, boolean) if the specified version is not part of this node's version history.");
        }
        catch (VersionException versionException) {
            // empty catch block
        }
    }

    public void testRestoreInvalidVersion2() throws RepositoryException {
        String invalidName;
        block2: do {
            invalidName = this.createRandomString(3);
            VersionIterator it = this.versionableNode.getVersionHistory().getAllVersions();
            while (it.hasNext()) {
                Version v = it.nextVersion();
                if (!invalidName.equals(v.getName())) continue;
                invalidName = null;
                continue block2;
            }
        } while (invalidName == null);
        try {
            this.versionableNode.restore(invalidName, true);
            RestoreTest.fail((String)"VersionException expected on Node.restore(String, boolean) if the specified version is not part of this node's version history.");
        }
        catch (VersionException versionException) {
            // empty catch block
        }
    }

    public void testRestoreNonVersionableNode() throws RepositoryException {
        try {
            this.nonVersionableNode.restore("foo", true);
            RestoreTest.fail((String)"Node.restore(String, boolean) on a non versionable node must throw UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testRestoreNonVersionableNode2() throws RepositoryException {
        try {
            this.nonVersionableNode.getParent().restore(this.version, this.nonVersionableNode.getName(), true);
            RestoreTest.fail((String)"Node.restore(Version, String, boolean) on a non versionable node must throw UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testRestoreNonVersionableNode3() throws RepositoryException {
        try {
            this.nonVersionableNode.restore(this.version, true);
            RestoreTest.fail((String)"Node.restore(Version, boolean) on a non versionable node must throw UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testRestoreWithInvalidVersion() throws RepositoryException {
        Version invalidVersion = this.versionableNode2.checkin();
        try {
            this.versionableNode.restore(invalidVersion, true);
            RestoreTest.fail((String)"Node.restore(Version, boolean): A VersionException must be thrown if the specified version does not exists in this node's version history.");
        }
        catch (VersionException versionException) {
            // empty catch block
        }
    }

    public void testRestoreWithUUIDConflict() throws RepositoryException, NotExecutableException {
        try {
            Node naa = this.createVersionableNode(this.versionableNode, this.nodeName4, this.versionableNodeType);
            NodeDefinition nd = naa.getDefinition();
            if (nd.getOnParentVersion() != 1 && nd.getOnParentVersion() != 2) {
                throw new NotExecutableException("Child nodes must have OPV COPY or VERSION in order to be able to test Node.restore with uuid conflict.");
            }
            Version v = this.versionableNode.checkin();
            this.versionableNode.checkout();
            this.superuser.move(naa.getPath(), this.versionableNode2.getPath() + "/" + naa.getName());
            this.superuser.save();
            this.versionableNode.restore(v, false);
            RestoreTest.fail((String)"Node.restore( Version, boolean ): An ItemExistsException must be thrown if the node to be restored already exsits and removeExisting was set to false.");
        }
        catch (ItemExistsException itemExistsException) {
            // empty catch block
        }
    }

    public void testRestoreChild1() throws RepositoryException {
        this.versionableNode.addNode("child1");
        this.versionableNode.save();
        Version v1 = this.versionableNode.checkin();
        this.versionableNode.checkout();
        Version v2 = this.versionableNode.checkin();
        this.versionableNode.restore(v1, true);
        RestoreTest.assertTrue((String)"Node.restore('1.2') must not remove child node.", (boolean)this.versionableNode.hasNode("child1"));
        this.versionableNode.restore(this.version, true);
        RestoreTest.assertFalse((String)"Node.restore('1.0') must remove child node.", (boolean)this.versionableNode.hasNode("child1"));
        try {
            this.versionableNode.restore(v2, true);
        }
        catch (RepositoryException e) {
            RestoreTest.fail((String)"Node.restore('1.3') must fail.");
        }
    }

    public void testRestoreLabel() throws RepositoryException {
        Version v1 = this.versionableNode.checkin();
        String v1Name = v1.getName();
        this.versionableNode.getVersionHistory().addVersionLabel(v1Name, "test", true);
        this.versionableNode.checkout();
        Version v2 = this.versionableNode.checkin();
        this.versionableNode.restoreByLabel("test", true);
        RestoreTest.assertEquals((String)"Node.restore('test') not correctly restored", (String)v1Name, (String)this.versionableNode.getBaseVersion().getName());
    }

    public void testRestoreName() throws RepositoryException {
        Node child1 = this.versionableNode.addNode(this.nodeName4);
        if (!child1.isNodeType(this.mixVersionable)) {
            child1.addMixin(this.mixVersionable);
        }
        this.versionableNode.save();
        Version v1Child = child1.checkin();
        String v1 = this.versionableNode.checkin().getName();
        child1.checkout();
        Version v11Child = child1.checkin();
        this.versionableNode.checkout();
        String v2 = this.versionableNode.checkin().getName();
        this.versionableNode.restore(this.version, true);
        RestoreTest.assertFalse((String)"Node.restore('1.0') must remove child node.", (boolean)this.versionableNode.hasNode(this.nodeName4));
        this.versionableNode.restore(v1, true);
        RestoreTest.assertTrue((String)"Node.restore('test') must restore child node.", (boolean)this.versionableNode.hasNode(this.nodeName4));
        child1 = this.versionableNode.getNode(this.nodeName4);
        RestoreTest.assertEquals((String)"Node.restore('test') must restore child node version 1.0.", (String)v1Child.getName(), (String)child1.getBaseVersion().getName());
        this.versionableNode.restore(v2, true);
        child1 = this.versionableNode.getNode(this.nodeName4);
        RestoreTest.assertEquals((String)"Node.restore('foo') must restore child node version 1.1.", (String)v11Child.getName(), (String)child1.getBaseVersion().getName());
    }

    public void testRestoreOrder() throws RepositoryException {
        Node child2;
        Node testRoot = this.versionableNode.addNode(this.nodeName4, "nt:unstructured");
        testRoot.addMixin(this.mixVersionable);
        this.versionableNode.save();
        Node child1 = testRoot.addNode(this.nodeName1);
        if (!child1.isNodeType(this.mixVersionable)) {
            child1.addMixin(this.mixVersionable);
        }
        if (!(child2 = testRoot.addNode(this.nodeName2)).isNodeType(this.mixVersionable)) {
            child2.addMixin(this.mixVersionable);
        }
        testRoot.save();
        child1.checkin();
        child2.checkin();
        Version v1 = testRoot.checkin();
        testRoot.checkout();
        child1.remove();
        testRoot.save();
        testRoot.checkin();
        testRoot.restore(v1, true);
        NodeIterator iter = testRoot.getNodes();
        RestoreTest.assertTrue((String)(testRoot.getName() + " should have 2 child nodes."), (boolean)iter.hasNext());
        Node n1 = iter.nextNode();
        RestoreTest.assertTrue((String)(testRoot.getName() + " should have 2 child nodes."), (boolean)iter.hasNext());
        Node n2 = iter.nextNode();
        String orderOk = this.nodeName1 + ", " + this.nodeName2;
        String order = n1.getName() + ", " + n2.getName();
        RestoreTest.assertEquals((String)"Invalid child node ordering", (String)orderOk, (String)order);
    }

    public void testRestoreOrder2() throws RepositoryException {
        Node child2;
        Node testRoot = this.versionableNode.addNode(this.nodeName4, "nt:unstructured");
        testRoot.addMixin(this.mixVersionable);
        this.versionableNode.save();
        Node child1 = testRoot.addNode(this.nodeName1);
        if (!child1.isNodeType(this.mixVersionable)) {
            child1.addMixin(this.mixVersionable);
        }
        if (!(child2 = testRoot.addNode(this.nodeName2)).isNodeType(this.mixVersionable)) {
            child2.addMixin(this.mixVersionable);
        }
        testRoot.save();
        child1.checkin();
        child2.checkin();
        Version v1 = testRoot.checkin();
        testRoot.checkout();
        testRoot.orderBefore(this.nodeName2, this.nodeName1);
        testRoot.save();
        testRoot.checkin();
        testRoot.restore(v1, true);
        NodeIterator iter = testRoot.getNodes();
        RestoreTest.assertTrue((String)(testRoot.getName() + " should have 2 child nodes."), (boolean)iter.hasNext());
        Node n1 = iter.nextNode();
        RestoreTest.assertTrue((String)(testRoot.getName() + " should have 2 child nodes."), (boolean)iter.hasNext());
        Node n2 = iter.nextNode();
        String orderOk = this.nodeName1 + ", " + this.nodeName2;
        String order = n1.getName() + ", " + n2.getName();
        RestoreTest.assertEquals((String)"Invalid child node ordering", (String)orderOk, (String)order);
    }
}

