/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Stack;
import javax.jcr.Item;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.Workspace;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.XMLChar;
import org.apache.jackrabbit.test.api.Base64;
import org.apache.jackrabbit.test.api.EscapeJCRUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ExportDocViewTest
extends AbstractJCRTest {
    private final boolean CONTENTHANDLER = true;
    private final boolean STREAM = false;
    private final boolean SKIPBINARY = true;
    private final boolean SAVEBINARY = false;
    private final boolean NORECURSE = true;
    private final boolean RECURSE = false;
    private String JCR_XMLTEXT;
    private String JCR_XMLDATA;
    private Stack textValuesStack;
    private boolean exportMultivalProps = false;
    private boolean exportInvalidXmlNames = false;
    private boolean skipBinary;
    private boolean noRecurse;
    private boolean withHandler;
    private File file;
    private Session session;
    private Workspace workspace;
    private NamespaceRegistry nsr;
    private String testPath;
    private Document doc;

    protected void setUp() throws Exception {
        this.isReadOnly = true;
        this.session = this.getHelper().getReadOnlySession();
        this.workspace = this.session.getWorkspace();
        this.nsr = this.workspace.getNamespaceRegistry();
        this.file = File.createTempFile("docViewExportTest", ".xml");
        super.setUp();
        this.JCR_XMLTEXT = this.session.getNamespacePrefix("http://www.jcp.org/jcr/1.0") + ":xmltext";
        this.JCR_XMLDATA = this.session.getNamespacePrefix("http://www.jcp.org/jcr/1.0") + ":xmlcharacters";
        this.testPath = this.testRoot;
    }

    protected void tearDown() throws Exception {
        this.file.delete();
        if (this.session != null) {
            this.session.logout();
            this.session = null;
        }
        this.workspace = null;
        this.nsr = null;
        super.tearDown();
    }

    public void testExportDocView_handler_session_skipBinary_noRecurse() throws IOException, RepositoryException, SAXException, TransformerException {
        this.doTestExportDocView(true, true, true);
    }

    public void testExportDocView_handler_session_skipBinary_recurse() throws IOException, RepositoryException, SAXException, TransformerException {
        this.doTestExportDocView(true, true, false);
    }

    public void testExportDocView_handler_session_saveBinary_noRecurse() throws IOException, RepositoryException, SAXException, TransformerException {
        this.doTestExportDocView(true, false, true);
    }

    public void testExportDocView_handler_session_saveBinary_recurse() throws IOException, RepositoryException, SAXException, TransformerException {
        this.doTestExportDocView(true, false, false);
    }

    public void testExportDocView_stream_session_skipBinary_recurse() throws IOException, RepositoryException, SAXException, TransformerException {
        this.doTestExportDocView(false, true, false);
    }

    public void testExportDocView_stream_session_skipBinary_noRecurse() throws IOException, RepositoryException, SAXException, TransformerException {
        this.doTestExportDocView(false, true, true);
    }

    public void testExportDocView_stream_session_saveBinary_noRecurse() throws IOException, RepositoryException, SAXException, TransformerException {
        this.doTestExportDocView(false, false, true);
    }

    public void testExportDocView_stream_session_saveBinary_recurse() throws IOException, RepositoryException, SAXException, TransformerException {
        this.doTestExportDocView(false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTestExportDocView(boolean withHandler, boolean skipBinary, boolean noRecurse) throws RepositoryException, IOException, SAXException, TransformerException {
        this.skipBinary = skipBinary;
        this.noRecurse = noRecurse;
        this.withHandler = withHandler;
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(this.file));
        try {
            if (withHandler) {
                SAXTransformerFactory stf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
                TransformerHandler th = stf.newTransformerHandler();
                th.setResult(new StreamResult(os));
                this.session.exportDocumentView(this.testPath, (ContentHandler)th, skipBinary, noRecurse);
            } else {
                this.session.exportDocumentView(this.testPath, (OutputStream)os, skipBinary, noRecurse);
            }
        }
        finally {
            os.close();
        }
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.file));
        this.doc = this.readDocument(in);
        this.compareTree();
    }

    private void compareTree() throws RepositoryException, IOException {
        Element root = this.doc.getDocumentElement();
        this.textValuesStack = new Stack();
        Item item = this.session.getItem(this.testPath);
        if (!item.isNode()) {
            ExportDocViewTest.fail((String)("Item at the given root path " + this.testPath + " is not a node."));
        }
        Node node = (Node)item;
        this.setExportMultivalProps(node, root, false);
        this.setExportInvalidXmlNames(node, root, false);
        this.checkRootElement(node, root);
        this.compareNamespaces(root);
        this.compareNode(node, root);
        if (!this.noRecurse) {
            this.checkChildNodes(node, root);
        }
    }

    private void checkRootElement(Node node, Element root) throws RepositoryException {
        boolean isValidName = XMLChar.isValidName(node.getName());
        if (root != null) {
            if (node.getDepth() == 0) {
                ExportDocViewTest.assertEquals((String)"Exported root node has not correct name jcr:root.", (String)"jcr:root", (String)root.getTagName());
            }
        } else if (this.exportInvalidXmlNames || isValidName) {
            ExportDocViewTest.fail((String)("Node " + node.getPath() + " is not exported."));
        }
    }

    private void checkChildNodes(Node node, Element elem) throws RepositoryException, IOException {
        NodeIterator nodeIter = node.getNodes();
        if (this.getSize((RangeIterator)node.getNodes()) == 0L) {
            ExportDocViewTest.assertTrue((String)("Exported node " + node.getPath() + " has child elements " + "although it has no child nodes "), (0L == this.countChildElems(elem) ? 1 : 0) != 0);
        } else {
            StackEntry entry = new StackEntry();
            entry.textValues = this.getChildTextNodeValues(elem);
            this.textValuesStack.push(entry);
            ArrayList<Node> jcrTextNodes = new ArrayList<Node>();
            while (nodeIter.hasNext()) {
                Node childNode = nodeIter.nextNode();
                if (this.isXMLTextNode(childNode)) {
                    jcrTextNodes.add(childNode);
                    continue;
                }
                if (jcrTextNodes.size() > 0) {
                    this.compareXmltextNodes(jcrTextNodes, elem);
                    jcrTextNodes.clear();
                }
                this.compareChildTree(childNode, elem);
            }
            this.textValuesStack.pop();
        }
    }

    private void compareChildTree(Node node, Element parentElem) throws RepositoryException, IOException {
        Element nodeElem = this.findElem(node, parentElem);
        if (nodeElem != null) {
            this.compareNode(node, nodeElem);
            this.checkChildNodes(node, nodeElem);
        }
    }

    private Element findElem(Node node, Element parentElem) throws RepositoryException {
        String name = node.getName();
        Element nodeElem = null;
        boolean isValidName = XMLChar.isValidName(name);
        ArrayList children = this.getChildElems(parentElem, name = !isValidName ? ExportDocViewTest.escapeNames(name) : name);
        if (children.size() > 0) {
            if (this.isXMLTextNode(node)) {
                ExportDocViewTest.fail((String)("Xml text node " + node.getPath() + " is wronlgy exported as element."));
            } else {
                int index = node.getIndex();
                try {
                    nodeElem = (Element)children.get(index - 1);
                }
                catch (IndexOutOfBoundsException iobe) {
                    ExportDocViewTest.fail((String)("Node " + node.getPath() + " is not exported." + iobe.toString()));
                }
            }
        } else if (!this.isXMLTextNode(node) && (isValidName || this.exportInvalidXmlNames)) {
            ExportDocViewTest.fail((String)("Node " + node.getPath() + " is not exported."));
        }
        return nodeElem;
    }

    private Attr findAttribute(Property prop, Element elem) throws RepositoryException {
        String name = prop.getName();
        boolean isValidName = XMLChar.isValidName(name);
        name = !isValidName ? ExportDocViewTest.escapeNames(name) : name;
        Attr attribute = elem.getAttributeNode(name);
        return attribute;
    }

    private void checkAttribute(Property prop, Attr attribute) throws RepositoryException {
        boolean isBinary = prop.getType() == 2;
        boolean isMultiple = prop.getDefinition().isMultiple();
        if (this.skipBinary) {
            if (isBinary && (!isMultiple || this.exportMultivalProps)) {
                ExportDocViewTest.assertEquals((String)("Value of binary property " + prop.getPath() + " exported although skipBinary is true"), (int)attribute.getValue().length(), (int)0);
            } else {
                this.checkExportFlags(prop, attribute);
            }
        } else {
            if (isBinary && (!isMultiple || this.exportMultivalProps)) {
                ExportDocViewTest.assertTrue((String)("Binary property " + prop.getPath() + " not exported although skipBinary is false"), (attribute != null ? 1 : 0) != 0);
            }
            this.checkExportFlags(prop, attribute);
        }
    }

    private void checkExportFlags(Property prop, Attr attribute) throws RepositoryException {
        String name = prop.getName();
        boolean isMultiple = prop.getDefinition().isMultiple();
        boolean isValidName = XMLChar.isValidName(name);
        if (isMultiple) {
            if (this.exportMultivalProps) {
                ExportDocViewTest.assertTrue((String)("Not all multivalued properties are exported: " + prop.getPath() + " is not exported."), (attribute != null ? 1 : 0) != 0);
            } else {
                return;
            }
        }
        if (this.exportInvalidXmlNames && !isValidName) {
            ExportDocViewTest.assertTrue((String)("Not all properties with invalid xml name are exported: " + prop.getPath() + " is not exported."), (attribute != null ? 1 : 0) != 0);
        } else {
            ExportDocViewTest.assertTrue((String)("Property " + prop.getPath() + " is not exported."), (attribute != null ? 1 : 0) != 0);
        }
    }

    private void compareNode(Node node, Element elem) throws RepositoryException, IOException {
        this.compareChildNumber(node, elem);
        this.comparePropNumber(node, elem);
        PropertyIterator propIter = node.getProperties();
        while (propIter.hasNext()) {
            Property prop = propIter.nextProperty();
            Attr attr = this.findAttribute(prop, elem);
            this.checkAttribute(prop, attr);
            if (attr == null) continue;
            this.compareProperty(prop, attr);
        }
    }

    private void compareProperty(Property prop, Attr attr) throws RepositoryException, IOException {
        boolean isMultiple = prop.getDefinition().isMultiple();
        boolean isBinary = prop.getType() == 2;
        String attrVal = attr.getValue();
        String val = null;
        if (isMultiple) {
            val = ExportDocViewTest.exportValues(prop, isBinary);
        } else if (isBinary) {
            try {
                attrVal = ExportDocViewTest.decodeBase64(attrVal);
                val = prop.getString();
            }
            catch (IOException ioe) {
                ExportDocViewTest.fail((String)("Could not decode value of binary attribute " + attr.getName() + " of element " + attr.getOwnerElement().getTagName()));
            }
        } else {
            val = prop.getString();
        }
        if (isBinary && this.skipBinary) {
            ExportDocViewTest.assertEquals((String)("Value of binary property " + prop.getPath() + " is not exported correctly: "), (String)"", (String)attrVal);
            ExportDocViewTest.assertEquals((String)("Value of binary property " + prop.getPath() + " exported although skipBinary is true"), (String)"", (String)attrVal);
        } else {
            ExportDocViewTest.assertTrue((String)("Value of property " + prop.getPath() + " is not exported correctly: " + attrVal), (val.equals(attrVal) || ExportDocViewTest.escapeValues(val).equals(attrVal) ? 1 : 0) != 0);
        }
    }

    private void compareNamespaces(Element root) throws RepositoryException {
        Properties nameSpaces = new AttributeSeparator(root).getNsAttrs();
        Enumeration<Object> e = nameSpaces.keys();
        while (e.hasMoreElements()) {
            String prefix = (String)e.nextElement();
            String URI2 = nameSpaces.getProperty(prefix);
            ExportDocViewTest.assertEquals((String)("Prefix of uri" + URI2 + "is not exported correctly."), (String)this.nsr.getPrefix(URI2), (String)prefix);
            ExportDocViewTest.assertEquals((String)("Uri of prefix " + prefix + "is not exported correctly."), (String)this.nsr.getURI(prefix), (String)URI2);
        }
        String[] registeredNamespaces = this.nsr.getURIs();
        for (int i = 0; i < registeredNamespaces.length; ++i) {
            String prefix = this.nsr.getPrefix(registeredNamespaces[i]);
            if (prefix.length() == 0 || prefix.startsWith("xml")) continue;
            ExportDocViewTest.assertTrue((String)("namespace: " + registeredNamespaces[i] + " not exported"), (boolean)nameSpaces.keySet().contains(prefix));
        }
    }

    private void compareChildNumber(Node node, Element elem) throws RepositoryException {
        NodeIterator iter = node.getNodes();
        long size = 0L;
        long exported = this.countChildElems(elem);
        if (!this.noRecurse) {
            size = this.getSize((RangeIterator)node.getNodes());
            while (iter.hasNext()) {
                Node n = iter.nextNode();
                String name = n.getName();
                if (this.isXMLTextNode(n)) {
                    --size;
                }
                if (this.exportInvalidXmlNames || XMLChar.isValidName(name)) continue;
                --size;
            }
        }
        ExportDocViewTest.assertEquals((String)("The number of child nodes of node  " + node.getPath() + " which are exported is not correct: "), (long)size, (long)exported);
    }

    private void comparePropNumber(Node node, Element elem) throws RepositoryException {
        PropertyIterator iter = node.getProperties();
        long size = this.getSize((RangeIterator)node.getProperties());
        long exported = new AttributeSeparator(elem).getNonNsAttrs().size();
        while (iter.hasNext()) {
            Property prop = iter.nextProperty();
            String name = prop.getName();
            boolean isMultiple = prop.getDefinition().isMultiple();
            if (!this.exportInvalidXmlNames && !XMLChar.isValidName(name)) {
                --size;
                continue;
            }
            if (this.exportMultivalProps || !isMultiple) continue;
            --size;
        }
        ExportDocViewTest.assertEquals((String)("The number of properties exported of node " + node.getPath() + " is not correct."), (long)size, (long)exported);
    }

    private void compareXmltextNodes(ArrayList nodes, Element parentElem) throws RepositoryException {
        if (this.withHandler) {
            String value = "";
            String exportedVal = "";
            StackEntry currentEntry = (StackEntry)this.textValuesStack.pop();
            try {
                exportedVal = (String)currentEntry.textValues.get(currentEntry.position);
                ++currentEntry.position;
                this.textValuesStack.push(currentEntry);
            }
            catch (IndexOutOfBoundsException iobe) {
                ExportDocViewTest.fail((String)("Xmltext nodes not correctly exported: " + iobe.getMessage()));
            }
            int size = nodes.size();
            if (size == 1) {
                Node node = (Node)nodes.get(0);
                Property prop = node.getProperty(this.JCR_XMLDATA);
                value = prop.getString();
                ExportDocViewTest.assertEquals((String)("The " + this.JCR_XMLTEXT + " node " + node.getPath() + " is not exported correctly."), (String)value, (String)exportedVal);
            } else {
                for (int i = 0; i < nodes.size(); ++i) {
                    Node node = (Node)nodes.get(i);
                    Property prop = node.getProperty(this.JCR_XMLDATA);
                    value = prop.getString();
                    if (i == 0) {
                        if (exportedVal.regionMatches(0, value, 0, value.length())) {
                            exportedVal = exportedVal.substring(0, value.length());
                            continue;
                        }
                        ExportDocViewTest.fail((String)("The " + this.JCR_XMLTEXT + " node " + node.getPath() + " is not exported correctly: expected: " + value + " found: " + exportedVal));
                        continue;
                    }
                    if (exportedVal.regionMatches(0, value, 0, value.length())) {
                        exportedVal = exportedVal.substring(0, value.length());
                        continue;
                    }
                    boolean match = false;
                    int j = 0;
                    char c = exportedVal.charAt(j);
                    while (c == ' ' || c == '\n' || c == '\r' || c == '\t' || c == '\u000b') {
                        if (exportedVal.regionMatches(j, value, 0, value.length())) {
                            exportedVal = exportedVal.substring(j, value.length() + j);
                            match = true;
                            break;
                        }
                        c = exportedVal.charAt(++j);
                    }
                    ExportDocViewTest.assertTrue((String)("The " + this.JCR_XMLTEXT + " node " + node.getPath() + " is not exported correctly: expected: " + value + " found: " + exportedVal), (boolean)match);
                }
            }
        }
    }

    private boolean setExportInvalidXmlNames(Node node, Element elem, boolean isSet) throws RepositoryException {
        PropertyIterator iter;
        if (!XMLChar.isValidName(node.getName())) {
            if (elem != null) {
                this.exportInvalidXmlNames = true;
                isSet = true;
            } else {
                this.exportInvalidXmlNames = false;
                isSet = true;
            }
        }
        if (!isSet) {
            iter = node.getProperties();
            while (iter.hasNext()) {
                Property prop = iter.nextProperty();
                if (!this.exportMultivalProps && prop.getDefinition().isMultiple() || XMLChar.isValidName(prop.getName())) continue;
                this.exportInvalidXmlNames = this.isExportedProp(prop, elem);
                isSet = true;
            }
        }
        if (!isSet && !this.noRecurse) {
            iter = node.getNodes();
            while (iter.hasNext()) {
                Node n = iter.nextNode();
                Element el = this.findElem(n, elem);
                isSet = this.setExportInvalidXmlNames(n, el, isSet);
            }
        }
        return isSet;
    }

    private boolean setExportMultivalProps(Node node, Element elem, boolean isSet) throws RepositoryException {
        Property[] props = this.searchMultivalProps(node);
        if (props[0] != null) {
            this.exportMultivalProps = this.isExportedProp(props[0], elem);
            isSet = true;
        } else if (props[1] != null) {
            this.exportMultivalProps = this.isExportedProp(props[1], elem);
            if (!this.exportMultivalProps && this.exportInvalidXmlNames) {
                isSet = true;
            }
        }
        if (!isSet && !this.noRecurse) {
            NodeIterator iter = node.getNodes();
            while (iter.hasNext()) {
                Node n = iter.nextNode();
                Element el = this.findElem(n, elem);
                if (el != null) {
                    isSet = this.setExportMultivalProps(n, el, isSet);
                    continue;
                }
                isSet = false;
            }
        }
        return isSet;
    }

    private Property[] searchMultivalProps(Node node) throws RepositoryException {
        Property[] properties = new Property[]{null, null};
        PropertyIterator props = node.getProperties();
        while (props.hasNext()) {
            Property property = props.nextProperty();
            if (!property.getDefinition().isMultiple()) continue;
            if (XMLChar.isValidName(property.getName())) {
                properties[0] = property;
                break;
            }
            properties[1] = property;
        }
        return properties;
    }

    private boolean isExportedProp(Property prop, Element elem) throws RepositoryException {
        String name = prop.getName();
        name = XMLChar.isValidName(prop.getName()) ? name : ExportDocViewTest.escapeNames(name);
        Attr attr = elem.getAttributeNode(name);
        return attr != null;
    }

    private boolean isXMLTextNode(Node node) throws RepositoryException {
        Property prop;
        boolean isTrue = node.getName().equals(this.JCR_XMLTEXT);
        isTrue = node.hasProperty(this.JCR_XMLDATA) ? !(prop = node.getProperty(this.JCR_XMLDATA)).getDefinition().isMultiple() && prop.getType() == 1 && this.getSize((RangeIterator)node.getProperties()) == 2L && this.getSize((RangeIterator)node.getNodes()) == 0L : false;
        return isTrue;
    }

    private static String decodeBase64(String str) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Base64.decode(str, (OutputStream)bos);
        String decoded = bos.toString("UTF-8");
        return decoded;
    }

    private static String encodeBase64(InputStream in) throws IOException {
        StringWriter writer = new StringWriter();
        Base64.encode(in, writer);
        return writer.getBuffer().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String exportValues(Property prop, boolean isBinary) throws RepositoryException, IOException {
        Value[] vals = prop.getValues();
        StringBuffer exportedVal = new StringBuffer();
        String space = "";
        if (isBinary) {
            for (int i = 0; i < vals.length; ++i) {
                exportedVal.append(space);
                InputStream in = vals[i].getStream();
                try {
                    exportedVal.append(ExportDocViewTest.encodeBase64(in));
                }
                finally {
                    in.close();
                }
                space = " ";
            }
        } else {
            for (int i = 0; i < vals.length; ++i) {
                exportedVal.append(space);
                exportedVal.append(ExportDocViewTest.escapeValues(vals[i].getString()));
                space = " ";
            }
        }
        return exportedVal.toString();
    }

    private static String escapeNames(String name) {
        return EscapeJCRUtil.escapeJCRNames(name);
    }

    private static String escapeValues(String value) {
        return EscapeJCRUtil.escapeJCRValues(value);
    }

    private ArrayList getChildElems(Element elem, String name) {
        ArrayList<org.w3c.dom.Node> children = new ArrayList<org.w3c.dom.Node>();
        for (org.w3c.dom.Node child = elem.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !name.equals("*") && !name.equals(child.getNodeName())) continue;
            children.add(child);
        }
        return children;
    }

    private long countChildElems(Element elem) {
        long length = 0L;
        for (org.w3c.dom.Node child = elem.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1) continue;
            ++length;
        }
        return length;
    }

    private ArrayList getChildTextNodeValues(Element elem) {
        ArrayList<String> textValues = new ArrayList<String>();
        StringBuffer buf = new StringBuffer();
        org.w3c.dom.Node child = elem.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 3) {
                while (child != null && child.getNodeType() == 3) {
                    buf.append(child.getNodeValue());
                    child = child.getNextSibling();
                }
                textValues.add(buf.toString());
                buf = new StringBuffer();
                continue;
            }
            child = child.getNextSibling();
        }
        return textValues;
    }

    private Document readDocument(InputStream xml) throws RepositoryException {
        try {
            StreamSource source = new StreamSource(xml);
            DOMResult result = new DOMResult();
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.transform(source, result);
            return (Document)result.getNode();
        }
        catch (TransformerException e) {
            throw new RepositoryException("Unable to read xml file", (Throwable)e);
        }
    }

    private class AttributeSeparator {
        private static final String xmlnsURI = "http://www.w3.org/2000/xmlns/";
        private static final String xmlnsPrefix = "xmlns";
        Element elem;
        NamedNodeMap attrs;
        Properties nsAttrs;
        Properties nonNsAttrs;

        AttributeSeparator(Element elem) {
            this.elem = elem;
            this.nsAttrs = new Properties();
            this.nonNsAttrs = new Properties();
            this.attrs = elem.getAttributes();
            this.separateAttrs();
        }

        public Properties getNsAttrs() {
            return this.nsAttrs;
        }

        public Properties getNonNsAttrs() {
            return this.nonNsAttrs;
        }

        private void separateAttrs() {
            for (int i = 0; i < this.attrs.getLength(); ++i) {
                Attr attribute = (Attr)this.attrs.item(i);
                if (xmlnsURI.equals(attribute.getNamespaceURI())) {
                    String localName = attribute.getLocalName();
                    if (xmlnsPrefix.equals(localName)) continue;
                    this.nsAttrs.put(localName, attribute.getValue());
                    continue;
                }
                this.nonNsAttrs.put(attribute.getName(), attribute.getValue());
            }
        }
    }

    private class StackEntry {
        ArrayList textValues;
        int position = 0;

        private StackEntry() {
        }
    }
}

