/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.Node;
import javax.jcr.Session;
import org.apache.jackrabbit.test.AbstractJCRTest;

public class HasPermissionTest
extends AbstractJCRTest {
    private static final String ACTION_ALL = "read,add_node,remove,set_property";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadOnlyPermission() throws Exception {
        Node n = this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        this.superuser.save();
        Session readOnly = this.getHelper().getReadOnlySession();
        try {
            String path = n.getPath();
            HasPermissionTest.assertTrue((boolean)readOnly.hasPermission(path, "read"));
            HasPermissionTest.assertFalse((boolean)readOnly.hasPermission(path + "newNode", "add_node"));
            HasPermissionTest.assertFalse((boolean)readOnly.hasPermission(path, "remove"));
            HasPermissionTest.assertFalse((boolean)readOnly.hasPermission(path, "set_property"));
            HasPermissionTest.assertFalse((boolean)readOnly.hasPermission(path, ACTION_ALL));
            HasPermissionTest.assertFalse((boolean)readOnly.hasPermission(path, "remove,set_property"));
        }
        finally {
            readOnly.logout();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReadWritePermission() throws Exception {
        Node n = this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        this.superuser.save();
        String path = n.getPath();
        Session rwSession = this.getHelper().getReadWriteSession();
        try {
            HasPermissionTest.assertTrue((boolean)rwSession.hasPermission(path, "read"));
            HasPermissionTest.assertTrue((boolean)rwSession.hasPermission(path + "newNode", "add_node"));
            HasPermissionTest.assertTrue((boolean)rwSession.hasPermission(path, "remove"));
            HasPermissionTest.assertTrue((boolean)rwSession.hasPermission(path, "set_property"));
            HasPermissionTest.assertTrue((boolean)rwSession.hasPermission(path, ACTION_ALL));
        }
        finally {
            rwSession.logout();
        }
    }

    public void testAdminPermission() throws Exception {
        Node n = this.testRootNode.addNode(this.nodeName2, this.testNodeType);
        this.superuser.save();
        String path = n.getPath();
        HasPermissionTest.assertTrue((boolean)this.superuser.hasPermission(path, "read"));
        HasPermissionTest.assertTrue((boolean)this.superuser.hasPermission(path + "newNode", "add_node"));
        HasPermissionTest.assertTrue((boolean)this.superuser.hasPermission(path, "remove"));
        HasPermissionTest.assertTrue((boolean)this.superuser.hasPermission(path, "set_property"));
        HasPermissionTest.assertTrue((boolean)this.superuser.hasPermission(path, ACTION_ALL));
    }
}

