/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.test.AbstractJCRTest;
import org.apache.jackrabbit.test.NotExecutableException;

public class SetValueReferenceTest
extends AbstractJCRTest {
    private Value value;
    private Node node;
    private Property property1;

    protected void setUp() throws Exception {
        super.setUp();
        this.node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.ensureReferenceable(this.node);
        this.value = this.superuser.getValueFactory().createValue(this.node);
        this.property1 = this.node.setProperty(this.propertyName1, this.value);
        this.superuser.save();
    }

    protected void tearDown() throws Exception {
        this.value = null;
        this.node = null;
        this.property1 = null;
        super.tearDown();
    }

    public void testNodeSession() throws RepositoryException, NotExecutableException {
        this.property1.setValue(this.node);
        this.superuser.save();
        SetValueReferenceTest.assertTrue((String)"Reference property not saved", (boolean)this.node.isSame((Item)this.property1.getNode()));
    }

    public void testNodeParent() throws RepositoryException {
        this.property1.setValue(this.node);
        this.node.save();
        SetValueReferenceTest.assertTrue((String)"Reference property not saved", (boolean)this.node.isSame((Item)this.property1.getNode()));
    }

    public void testRemoveNodeSession() throws RepositoryException {
        this.property1.setValue((Value)null);
        this.superuser.save();
        try {
            this.node.getProperty(this.propertyName1);
            SetValueReferenceTest.fail((String)"The property should not exist anymore, as a null Value has been assigned");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testRemoveNodeParent() throws RepositoryException {
        this.property1.setValue((Node)null);
        this.node.save();
        try {
            this.node.getProperty(this.propertyName1);
            SetValueReferenceTest.fail((String)"The property should not exist anymore, as a null Value has been assigned");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    private void ensureReferenceable(Node n) throws RepositoryException, NotExecutableException {
        this.ensureMixinType(n, this.mixReferenceable);
        n.getSession().save();
    }
}

