/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.query;

import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.QueryResult;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.query.AbstractQueryTest;
import org.apache.jackrabbit.test.api.query.Statement;

public class XPathPosIndexTest
extends AbstractQueryTest {
    protected void setUp() throws Exception {
        this.isReadOnly = true;
        super.setUp();
    }

    public void testDocOrderIndexedNotation() throws Exception {
        String path = this.testRoot + "/" + this.nodeName1 + "[2]";
        StringBuffer tmp = new StringBuffer("/");
        tmp.append(this.jcrRoot).append(path);
        this.docOrderTest(new Statement(tmp.toString(), "xpath"), path);
    }

    private void docOrderTest(Statement stmt, String path) throws RepositoryException, NotExecutableException {
        if (!this.isSupported("query.xpath.pos.index")) {
            throw new NotExecutableException("Repository does not support document order on result set.");
        }
        int count = 0;
        NodeIterator it = this.testRootNode.getNodes();
        while (it.hasNext()) {
            ++count;
            it.nextNode();
        }
        if (count < 3) {
            throw new NotExecutableException("Workspace does not contain enough content under: " + this.testRoot + ". At least 3 nodes are required for this test.");
        }
        QueryResult result = this.execute(stmt);
        this.checkResult(result, 1);
        XPathPosIndexTest.assertEquals((String)"Wrong result node.", (String)path, (String)result.getNodes().nextNode().getPath());
    }
}

