/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.version;

import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.version.VersionManager;
import org.apache.jackrabbit.test.api.version.AbstractVersionTest;

public class CheckoutTest
extends AbstractVersionTest {
    protected void setUp() throws Exception {
        super.setUp();
        VersionManager versionManager = this.versionableNode.getSession().getWorkspace().getVersionManager();
        String path = this.versionableNode.getPath();
        if (!versionManager.isCheckedOut(path)) {
            CheckoutTest.fail((String)"A versionable node must be checked-out after persistent creation.");
        }
        if (!this.versionableNode.isCheckedOut()) {
            CheckoutTest.fail((String)"A versionable node must be checked-out after persistent creation.");
        }
        versionManager.checkin(path);
    }

    public void testIsCheckedOut() throws RepositoryException {
        this.versionableNode.checkout();
        CheckoutTest.assertTrue((String)"After calling Node.checkout() a versionable node N, N.isCheckedOut() must return true.", (boolean)this.versionableNode.isCheckedOut());
    }

    public void testIsCheckedOutJcr2() throws RepositoryException {
        VersionManager versionManager = this.versionableNode.getSession().getWorkspace().getVersionManager();
        String path = this.versionableNode.getPath();
        versionManager.checkout(path);
        CheckoutTest.assertTrue((String)"After successfully calling VersionManager.checkout(P) with P denoting the absolute path of a versionable node, VersionManager.isCheckedOut(P) must return true.", (boolean)versionManager.isCheckedOut(path));
    }

    public void testIsCheckedOutNonVersionableNode() throws RepositoryException {
        boolean isCheckedOut = this.nonVersionableNode.isCheckedOut();
        Node vParent = null;
        try {
            vParent = this.nonVersionableNode.getParent();
            while (!vParent.isNodeType(this.mixVersionable)) {
                vParent = vParent.getParent();
            }
        }
        catch (ItemNotFoundException itemNotFoundException) {
            // empty catch block
        }
        if (vParent != null && vParent.isNodeType(this.mixVersionable)) {
            if (vParent.isCheckedOut()) {
                CheckoutTest.assertTrue((String)"Node.isCheckedOut() must return true if the node is non-versionable and its nearest versionable ancestor is checked-out.", (boolean)isCheckedOut);
            } else {
                CheckoutTest.assertFalse((String)"Node.isCheckedOut() must return false if the node is non-versionable and its nearest versionable ancestor is checked-in.", (boolean)isCheckedOut);
            }
        } else {
            CheckoutTest.assertTrue((String)"Node.isCheckedOut() must return true if the node is non-versionable and has no versionable ancestor", (boolean)isCheckedOut);
        }
    }

    public void testIsCheckedOutNonVersionableNodeJcr2() throws RepositoryException {
        VersionManager versionManager = this.nonVersionableNode.getSession().getWorkspace().getVersionManager();
        String path = this.nonVersionableNode.getPath();
        boolean isCheckedOut = versionManager.isCheckedOut(path);
        Node vParent = null;
        try {
            vParent = this.nonVersionableNode.getParent();
            while (!vParent.isNodeType(this.mixVersionable)) {
                vParent = vParent.getParent();
            }
        }
        catch (ItemNotFoundException e) {
            // empty catch block
        }
        if (vParent != null && vParent.isNodeType(this.mixVersionable)) {
            String parentPath = vParent.getPath();
            if (versionManager.isCheckedOut(parentPath)) {
                CheckoutTest.assertTrue((String)"VersionManager.isCheckedOut(P) must return true if P denotes the absolute path of a non-versionable node whose nearest versionable ancestor is checked-out.", (boolean)isCheckedOut);
            } else {
                CheckoutTest.assertFalse((String)"VersionManager.isCheckedOut(P) must return false if P denotes the absolute path of a non-versionable node whose nearest versionable ancestor is checked-in.", (boolean)isCheckedOut);
            }
        } else {
            CheckoutTest.assertTrue((String)"VersionManager.isCheckedOut(P) must return true if P denotes the absolute path of a non-versionable node that has no versionable ancestor", (boolean)isCheckedOut);
        }
    }

    public void testCheckoutNonVersionableNode() throws RepositoryException {
        try {
            this.nonVersionableNode.checkout();
            CheckoutTest.fail((String)"Node.checkout() on a non-versionable node must throw UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testCheckoutNonVersionableNodeJcr2() throws RepositoryException {
        VersionManager versionManager = this.nonVersionableNode.getSession().getWorkspace().getVersionManager();
        String path = this.nonVersionableNode.getPath();
        try {
            versionManager.checkout(path);
            CheckoutTest.fail((String)"VersionManager.checkout(P) with P denoting the absolute path of a non-versionable node must throw UnsupportedRepositoryOperationException");
        }
        catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
            // empty catch block
        }
    }

    public void testCheckoutTwiceDoesNotThrow() throws RepositoryException {
        this.versionableNode.checkout();
        this.versionableNode.checkout();
    }

    public void testCheckoutTwiceDoesNotThrowJcr2() throws RepositoryException {
        VersionManager versionManager = this.versionableNode.getSession().getWorkspace().getVersionManager();
        String path = this.versionableNode.getPath();
        versionManager.checkout(path);
        versionManager.checkout(path);
    }

    public void testCheckoutCopiesBaseValueToPredecessorProperty() throws RepositoryException {
        Value baseVersionValue = this.versionableNode.getProperty(this.jcrBaseVersion).getValue();
        this.versionableNode.checkout();
        Value[] predecessorsValues = this.versionableNode.getProperty(this.jcrPredecessors).getValues();
        boolean foundBaseVersionProp = false;
        for (int i = 0; i < predecessorsValues.length && !foundBaseVersionProp; ++i) {
            if (!predecessorsValues[i].equals(baseVersionValue)) continue;
            foundBaseVersionProp = true;
        }
        if (!foundBaseVersionProp) {
            CheckoutTest.fail((String)"After calling Node.checkout() the current value of node's jcr:baseVersion must be copied to node's jcr:predecessors property");
        }
    }

    public void testCheckoutCopiesBaseValueToPredecessorPropertyJcr2() throws RepositoryException {
        VersionManager versionManager = this.versionableNode.getSession().getWorkspace().getVersionManager();
        String path = this.versionableNode.getPath();
        Value baseVersionValue = this.versionableNode.getProperty(this.jcrBaseVersion).getValue();
        versionManager.checkout(path);
        Value[] predecessorsValues = this.versionableNode.getProperty(this.jcrPredecessors).getValues();
        boolean foundBaseVersionProp = false;
        for (int i = 0; i < predecessorsValues.length && !foundBaseVersionProp; ++i) {
            if (!predecessorsValues[i].equals(baseVersionValue)) continue;
            foundBaseVersionProp = true;
        }
        if (!foundBaseVersionProp) {
            CheckoutTest.fail((String)"After calling Node.checkout() the current value of node's jcr:baseVersion must be copied to node's jcr:predecessors property");
        }
    }
}

