/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.version.simple;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Workspace;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionManager;
import org.apache.jackrabbit.test.api.version.simple.AbstractVersionTest;

public class CopyTest
extends AbstractVersionTest {
    protected void setUp() throws Exception {
        super.setUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void tearDown() throws Exception {
        try {
            String dstPath = this.getProperty("destination");
            this.superuser.getNode(dstPath).remove();
            this.testRootNode.getSession().save();
        }
        catch (Exception e) {
            this.log.println("Exception in tearDown: " + e.toString());
        }
        finally {
            super.tearDown();
        }
    }

    public void testCopy() throws RepositoryException {
        Workspace wsp = this.superuser.getWorkspace();
        VersionManager vMgr = wsp.getVersionManager();
        String srcPath = this.versionableNode.getPath();
        String dstPath = this.getProperty("destination");
        wsp.copy(srcPath, dstPath);
        Node v = this.superuser.getNode(dstPath);
        CopyTest.assertTrue((String)"Copied Node.isNodeType(mix:simpleVersionable) must return true.", (boolean)v.isNodeType(this.mixSimpleVersionable));
        CopyTest.assertFalse((String)"Copied Node.isNodeType(mix:versionable) must return false.", (boolean)v.isNodeType(this.mixVersionable));
        VersionHistory vh1 = vMgr.getVersionHistory(srcPath);
        VersionHistory vh2 = vMgr.getVersionHistory(dstPath);
        CopyTest.assertFalse((String)"Copied node needs a new version history.", (boolean)vh1.isSame((Item)vh2));
        CopyTest.assertEquals((String)"Copied node must have 1 version.", (long)1L, (long)this.getNumberOfVersions(vh2));
    }
}

