/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.test.AbstractJCRTest;

public class PropertyItemIsModifiedTest
extends AbstractJCRTest {
    protected Node testNode;

    protected void setUp() throws Exception {
        super.setUp();
        try {
            this.testNode = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
            this.testRootNode.save();
        }
        catch (RepositoryException e) {
            PropertyItemIsModifiedTest.fail((String)("Failed to create test node." + e.getMessage()));
        }
    }

    protected void tearDown() throws Exception {
        this.testNode = null;
        super.tearDown();
    }

    public void testTransientNewPropertyItemIsModified() throws RepositoryException {
        Property testProperty = this.testNode.setProperty(this.propertyName1, "test");
        Item testPropertyItem = this.superuser.getItem(testProperty.getPath());
        PropertyItemIsModifiedTest.assertFalse((String)"Item.isModified() must return false directly after a new PropertyItem is set (before current node is saved)", (boolean)testPropertyItem.isModified());
    }

    public void testPersistentNewPropertyItemIsModified() throws RepositoryException {
        Property testProperty = this.testNode.setProperty(this.propertyName1, "test");
        this.testNode.save();
        Item testPropertyItem = this.superuser.getItem(testProperty.getPath());
        PropertyItemIsModifiedTest.assertFalse((String)"Item.isModified() must return false after a new PropertyItem is set and current node is saved", (boolean)testPropertyItem.isModified());
    }

    public void testTransientPropertyItemIsModified() throws RepositoryException {
        Property testProperty = this.testNode.setProperty(this.propertyName1, "test1");
        this.testNode.save();
        testProperty.setValue("test2");
        Item testPropertyItem = this.superuser.getItem(testProperty.getPath());
        PropertyItemIsModifiedTest.assertTrue((String)"Item.isModified() must return true directly after an existing Property is modified (before current node is saved)", (boolean)testPropertyItem.isModified());
    }

    public void testPersistentPropertyItemIsModified() throws RepositoryException {
        Property testProperty = this.testNode.setProperty(this.propertyName1, "test1");
        this.testNode.save();
        testProperty.setValue("test2");
        this.testNode.save();
        Item testPropertyItem = this.superuser.getItem(testProperty.getPath());
        PropertyItemIsModifiedTest.assertFalse((String)"Item.isModified() must return false after an existing Property is modified and the current Node is saved", (boolean)testPropertyItem.isModified());
    }
}

