/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.query;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.qom.Constraint;
import javax.jcr.query.qom.DynamicOperand;
import javax.jcr.query.qom.Ordering;
import javax.jcr.query.qom.QueryObjectModel;
import javax.jcr.query.qom.Source;
import org.apache.jackrabbit.test.api.query.AbstractQueryTest;

class AbstractOrderByTest
extends AbstractQueryTest {
    protected boolean checkSQL;
    private String[] nodeNames;

    AbstractOrderByTest() {
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.checkSQL = this.isSupported("option.query.sql.supported");
        this.nodeNames = new String[]{this.nodeName1, this.nodeName2, this.nodeName3, this.nodeName4};
    }

    protected void populate(String[] values) throws RepositoryException {
        for (int i = 0; i < values.length; ++i) {
            Node node = this.testRootNode.addNode(this.nodeNames[i], this.testNodeType);
            node.setProperty(this.propertyName1, values[i]);
        }
        this.superuser.save();
    }

    protected void populate(String[] values, int type) throws RepositoryException {
        for (int i = 0; i < values.length; ++i) {
            Node node = this.testRootNode.addNode(this.nodeNames[i], this.testNodeType);
            node.setProperty(this.propertyName1, this.vf.createValue(values[i], type));
        }
        this.superuser.save();
    }

    protected void populate(Calendar[] values) throws RepositoryException {
        for (int i = 0; i < values.length; ++i) {
            Node node = this.testRootNode.addNode(this.nodeNames[i], this.testNodeType);
            node.setProperty(this.propertyName1, values[i]);
        }
        this.superuser.save();
    }

    protected void populate(long[] values) throws RepositoryException {
        for (int i = 0; i < values.length; ++i) {
            Node node = this.testRootNode.addNode(this.nodeNames[i], this.testNodeType);
            node.setProperty(this.propertyName1, values[i]);
        }
        this.superuser.save();
    }

    protected void populate(double[] values) throws RepositoryException {
        for (int i = 0; i < values.length; ++i) {
            Node node = this.testRootNode.addNode(this.nodeNames[i], this.testNodeType);
            node.setProperty(this.propertyName1, values[i]);
        }
        this.superuser.save();
    }

    protected void populate(BigDecimal[] values) throws RepositoryException {
        for (int i = 0; i < values.length; ++i) {
            Node node = this.testRootNode.addNode(this.nodeNames[i], this.testNodeType);
            node.setProperty(this.propertyName1, values[i]);
        }
        this.superuser.save();
    }

    protected void checkOrder(String[] nodeNames) throws RepositoryException {
        QueryResult result;
        QueryObjectModel q;
        String sql = this.createSQL();
        String xpath = this.createXPath();
        if (sql != null) {
            q = this.superuser.getWorkspace().getQueryManager().createQuery(sql, "sql");
            result = q.execute();
            this.checkResultOrder(result, nodeNames);
        }
        if (xpath != null) {
            q = this.superuser.getWorkspace().getQueryManager().createQuery(xpath, "xpath");
            result = q.execute();
            this.checkResultOrder(result, nodeNames);
        }
        q = this.createQOM(true);
        result = q.execute();
        this.checkResultOrder(result, nodeNames);
        Collections.reverse(Arrays.asList(nodeNames));
        if (sql != null) {
            q = this.superuser.getWorkspace().getQueryManager().createQuery(sql + " DESC", "sql");
            result = q.execute();
            this.checkResultOrder(result, nodeNames);
        }
        if (xpath != null) {
            q = this.superuser.getWorkspace().getQueryManager().createQuery(xpath + " descending", "xpath");
            result = q.execute();
            this.checkResultOrder(result, nodeNames);
        }
        q = this.createQOM(false);
        result = q.execute();
        this.checkResultOrder(result, nodeNames);
    }

    protected void checkResultOrder(QueryResult result, String[] nodeNames) throws RepositoryException {
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeIterator it = result.getNodes();
        while (it.hasNext()) {
            nodes.add(it.nextNode());
        }
        AbstractOrderByTest.assertEquals((String)"Wrong hit count:", (int)nodeNames.length, (int)nodes.size());
        for (int i = 0; i < nodeNames.length; ++i) {
            String name = ((Node)nodes.get(i)).getName();
            AbstractOrderByTest.assertEquals((String)"Wrong order of nodes:", (String)nodeNames[i], (String)name);
        }
    }

    protected QueryObjectModel createQOM(boolean ascending) throws RepositoryException {
        DynamicOperand op = this.createOrderingOperand();
        Ordering ordering = ascending ? this.qf.ascending(op) : this.qf.descending(op);
        return this.qf.createQuery((Source)this.qf.selector(this.testNodeType, "s"), (Constraint)this.qf.descendantNode("s", this.testRoot), new Ordering[]{ordering}, null);
    }

    protected DynamicOperand createOrderingOperand() throws RepositoryException {
        return this.qf.propertyValue("s", this.propertyName1);
    }

    protected String createSQL() {
        if (this.checkSQL) {
            return "SELECT " + this.escapeIdentifierForSQL(this.propertyName1) + " FROM " + this.escapeIdentifierForSQL(this.testNodeType) + " WHERE " + this.jcrPath + " LIKE '" + this.testRoot + "/%' ORDER BY " + this.escapeIdentifierForSQL(this.propertyName1);
        }
        return null;
    }

    protected String createXPath() throws RepositoryException {
        List<String> languages = Arrays.asList(this.superuser.getWorkspace().getQueryManager().getSupportedQueryLanguages());
        if (languages.contains("xpath")) {
            return this.xpathRoot + "/*[@jcr:primaryType='" + this.testNodeType + "'] order by @" + this.propertyName1;
        }
        return null;
    }
}

