/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.version;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionManager;
import org.apache.jackrabbit.test.api.version.AbstractOnParentVersionTest;

public class OnParentVersionInitializeTest
extends AbstractOnParentVersionTest {
    protected void setUp() throws Exception {
        this.OPVAction = 3;
        super.setUp();
    }

    public void testRestoreProp() throws RepositoryException {
        Node propParent = this.p.getParent();
        propParent.checkout();
        Version v = propParent.checkin();
        propParent.checkout();
        this.p.setValue(this.newPropValue);
        this.p.save();
        propParent.restore(v, false);
        OnParentVersionInitializeTest.assertEquals((String)"On restore of a OnParentVersion-INITIALIZE property P, the current value of P must be left unchanged.", (String)this.p.getString(), (String)this.newPropValue);
    }

    public void testRestorePropJcr2() throws RepositoryException {
        Node propParent = this.p.getParent();
        VersionManager versionManager = propParent.getSession().getWorkspace().getVersionManager();
        String path = propParent.getPath();
        versionManager.checkout(path);
        Version v = versionManager.checkin(path);
        versionManager.checkout(path);
        this.p.setValue(this.newPropValue);
        this.p.getSession().save();
        versionManager.restore(v, false);
        OnParentVersionInitializeTest.assertEquals((String)"On restore of a OnParentVersion-INITIALIZE property P, the current value of P must be left unchanged.", (String)this.p.getString(), (String)this.newPropValue);
    }
}

