/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import javax.jcr.Node;
import javax.jcr.Value;
import org.apache.jackrabbit.test.AbstractJCRTest;

public class SetPropertyDoubleTest
extends AbstractJCRTest {
    private Node testNode;
    private double d1 = 1.23E20;
    private double d2 = 1.24E21;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.testNode = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        this.ensureCanSetProperty(this.testNode, this.propertyName1, this.testNode.getSession().getValueFactory().createValue(0.0));
    }

    @Override
    protected void tearDown() throws Exception {
        this.testNode = null;
        super.tearDown();
    }

    public void testNewDoublePropertySession() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.d1);
        this.superuser.save();
        SetPropertyDoubleTest.assertEquals((String)"Setting property with Node.setProperty(String, double) and Session.save() not working", (Object)new Double(this.d1), (Object)new Double(this.testNode.getProperty(this.propertyName1).getDouble()));
    }

    public void testModifyDoublePropertySession() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.d1);
        this.superuser.save();
        this.testNode.setProperty(this.propertyName1, this.d2);
        this.superuser.save();
        SetPropertyDoubleTest.assertEquals((String)"Modifying property with Node.setProperty(String, double) and Session.save() not working", (Object)new Double(this.d2), (Object)new Double(this.testNode.getProperty(this.propertyName1).getDouble()));
    }

    public void testNewDoublePropertyParent() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.d1);
        this.testRootNode.getSession().save();
        SetPropertyDoubleTest.assertEquals((String)"Setting property with Node.setProperty(String, double) and parentNode.save() not working", (Object)new Double(this.d1), (Object)new Double(this.testNode.getProperty(this.propertyName1).getDouble()));
    }

    public void testModifyDoublePropertyParent() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.d1);
        this.testRootNode.getSession().save();
        this.testNode.setProperty(this.propertyName1, this.d2);
        this.testRootNode.getSession().save();
        SetPropertyDoubleTest.assertEquals((String)"Modifying property with Node.setProperty(String, double) and parentNode.save() not working", (Object)new Double(this.d2), (Object)new Double(this.testNode.getProperty(this.propertyName1).getDouble()));
    }

    public void testRemoveDoublePropertySession() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.d1);
        this.superuser.save();
        this.testNode.setProperty(this.propertyName1, (Value)null);
        this.superuser.save();
        SetPropertyDoubleTest.assertFalse((String)"Removing double property with Node.setProperty(String, null) and Session.save() not working", (boolean)this.testNode.hasProperty(this.propertyName1));
    }

    public void testRemoveDoublePropertyParent() throws Exception {
        this.testNode.setProperty(this.propertyName1, this.d1);
        this.testRootNode.getSession().save();
        this.testNode.setProperty(this.propertyName1, (Value)null);
        this.testRootNode.getSession().save();
        SetPropertyDoubleTest.assertFalse((String)"Removing double property with Node.setProperty(String, null) and parentNode.save() not working", (boolean)this.testNode.hasProperty(this.propertyName1));
    }

    public void testEdgeCases() throws Exception {
        double[] tests = new double[]{Double.NaN, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY};
        String path = this.testNode.getPath();
        for (double v : tests) {
            this.testNode.setProperty(this.propertyName1, v);
            this.testRootNode.getSession().save();
            SetPropertyDoubleTest.assertEquals((String)("Round-trip of " + v), (Object)v, (Object)this.superuser.getNode(path).getProperty(this.propertyName1).getDouble());
        }
    }
}

