/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.nodetype;

import java.util.Arrays;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeDefinitionTemplate;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeExistsException;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.NodeTypeTemplate;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.nodetype.PropertyDefinitionTemplate;
import org.apache.jackrabbit.test.AbstractJCRTest;

public class NodeTypeCreationTest
extends AbstractJCRTest {
    private String expandedPropName;
    private String jcrPropName;
    private NodeTypeManager ntm;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.ntm = this.superuser.getWorkspace().getNodeTypeManager();
        super.checkSupportedOption("option.node.type.management.supported");
        this.expandedPropName = "{http://www.jcp.org/jcr/1.0}boolean";
        this.jcrPropName = this.superuser.getNamespacePrefix("http://www.jcp.org/jcr/1.0") + ":boolean";
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testEmptyNodeTypeTemplate() throws Exception {
        NodeTypeTemplate ntt = this.ntm.createNodeTypeTemplate();
        NodeTypeCreationTest.assertNull((Object)ntt.getName());
        NodeTypeCreationTest.assertFalse((boolean)ntt.isMixin());
        NodeTypeCreationTest.assertFalse((boolean)ntt.isAbstract());
        NodeTypeCreationTest.assertFalse((boolean)ntt.hasOrderableChildNodes());
        NodeTypeCreationTest.assertNotNull((Object)ntt.getDeclaredSupertypeNames());
        NodeTypeCreationTest.assertEquals((int)0, (int)ntt.getDeclaredSupertypeNames().length);
        NodeTypeCreationTest.assertNull((Object)ntt.getPrimaryItemName());
        NodeTypeCreationTest.assertNull((Object)ntt.getDeclaredChildNodeDefinitions());
        NodeTypeCreationTest.assertNull((Object)ntt.getDeclaredPropertyDefinitions());
        NodeTypeCreationTest.assertNotNull((Object)ntt.getNodeDefinitionTemplates());
        NodeTypeCreationTest.assertTrue((boolean)ntt.getNodeDefinitionTemplates().isEmpty());
        NodeTypeCreationTest.assertNotNull((Object)ntt.getPropertyDefinitionTemplates());
        NodeTypeCreationTest.assertTrue((boolean)ntt.getPropertyDefinitionTemplates().isEmpty());
    }

    public void testNonEmptyNodeTypeTemplate() throws Exception {
        NodeType ntd = this.ntm.getNodeType("nt:address");
        NodeTypeTemplate ntt = this.ntm.createNodeTypeTemplate((NodeTypeDefinition)this.ntm.getNodeType("nt:address"));
        NodeTypeCreationTest.assertEquals((String)ntt.getName(), (String)ntd.getName());
        NodeTypeCreationTest.assertEquals((boolean)ntt.isMixin(), (boolean)ntd.isMixin());
        NodeTypeCreationTest.assertEquals((boolean)ntt.isAbstract(), (boolean)ntd.isAbstract());
        NodeTypeCreationTest.assertEquals((boolean)ntt.hasOrderableChildNodes(), (boolean)ntd.hasOrderableChildNodes());
        NodeTypeCreationTest.assertEquals((boolean)ntt.isQueryable(), (boolean)ntd.isQueryable());
        NodeTypeCreationTest.assertEquals((String)ntt.getPrimaryItemName(), (String)ntd.getPrimaryItemName());
        NodeTypeCreationTest.assertTrue((boolean)Arrays.equals(ntt.getDeclaredSupertypeNames(), ntd.getDeclaredSupertypeNames()));
        NodeDefinition[] nda = ntt.getDeclaredChildNodeDefinitions();
        NodeDefinition[] nda1 = ntd.getDeclaredChildNodeDefinitions();
        NodeTypeCreationTest.assertEquals((int)nda.length, (int)nda1.length);
        for (int i = 0; i < nda.length; ++i) {
            NodeTypeCreationTest.assertEquals((String)nda[i].getName(), (String)nda1[i].getName());
            NodeTypeCreationTest.assertEquals((boolean)nda[i].allowsSameNameSiblings(), (boolean)nda1[i].allowsSameNameSiblings());
            NodeTypeCreationTest.assertTrue((boolean)Arrays.equals(nda[i].getRequiredPrimaryTypeNames(), nda1[i].getRequiredPrimaryTypeNames()));
            NodeTypeCreationTest.assertEquals((String)nda[i].getDefaultPrimaryTypeName(), (String)nda1[i].getDefaultPrimaryTypeName());
            NodeTypeCreationTest.assertEquals((Object)nda[i].getRequiredPrimaryTypeNames(), (Object)nda1[i].getRequiredPrimaryTypeNames());
        }
        PropertyDefinition[] pda = ntt.getDeclaredPropertyDefinitions();
        PropertyDefinition[] pda1 = ntd.getDeclaredPropertyDefinitions();
        NodeTypeCreationTest.assertEquals((int)pda.length, (int)pda1.length);
        for (int i = 0; i < pda.length; ++i) {
            NodeTypeCreationTest.assertEquals((String)pda[i].getName(), (String)pda1[i].getName());
            NodeTypeCreationTest.assertEquals((int)pda[i].getRequiredType(), (int)pda1[i].getRequiredType());
            NodeTypeCreationTest.assertTrue((boolean)Arrays.equals(pda[i].getAvailableQueryOperators(), pda1[i].getAvailableQueryOperators()));
            NodeTypeCreationTest.assertTrue((boolean)Arrays.equals(pda[i].getValueConstraints(), pda1[i].getValueConstraints()));
            NodeTypeCreationTest.assertEquals((boolean)pda[i].isFullTextSearchable(), (boolean)pda1[i].isFullTextSearchable());
            NodeTypeCreationTest.assertEquals((boolean)pda[i].isMultiple(), (boolean)pda1[i].isMultiple());
            NodeTypeCreationTest.assertEquals((boolean)pda[i].isQueryOrderable(), (boolean)pda1[i].isQueryOrderable());
        }
    }

    public void testNewNodeTypeTemplate() throws Exception {
        String expandedName = "{http://www.jcp.org/jcr/mix/1.0}littlemixin";
        String jcrName = this.superuser.getNamespacePrefix("http://www.jcp.org/jcr/mix/1.0") + ":littlemixin";
        NodeTypeTemplate ntt = this.ntm.createNodeTypeTemplate();
        ntt.setName(expandedName);
        NodeTypeCreationTest.assertEquals((String)jcrName, (String)ntt.getName());
        ntt.setName(jcrName);
        NodeTypeCreationTest.assertEquals((String)jcrName, (String)ntt.getName());
        ntt.setAbstract(false);
        NodeTypeCreationTest.assertFalse((boolean)ntt.isAbstract());
        try {
            ntt.setDeclaredSuperTypeNames(null);
            NodeTypeCreationTest.fail((String)"null isn't a valid array of jcr name");
        }
        catch (ConstraintViolationException e) {
            // empty catch block
        }
        NodeTypeCreationTest.assertNotNull((Object)ntt.getDeclaredSupertypeNames());
        NodeTypeCreationTest.assertEquals((int)0, (int)ntt.getDeclaredSupertypeNames().length);
        ntt.setDeclaredSuperTypeNames(new String[]{this.mixReferenceable});
        NodeTypeCreationTest.assertNotNull((Object)ntt.getDeclaredSupertypeNames());
        NodeTypeCreationTest.assertEquals((int)1, (int)ntt.getDeclaredSupertypeNames().length);
        NodeTypeCreationTest.assertEquals((String)this.mixReferenceable, (String)ntt.getDeclaredSupertypeNames()[0]);
        ntt.setMixin(true);
        NodeTypeCreationTest.assertTrue((boolean)ntt.isMixin());
        ntt.setOrderableChildNodes(true);
        NodeTypeCreationTest.assertTrue((boolean)ntt.hasOrderableChildNodes());
        ntt.setQueryable(false);
        NodeTypeCreationTest.assertFalse((boolean)ntt.isQueryable());
        ntt.setPrimaryItemName(null);
        NodeTypeCreationTest.assertNull((Object)ntt.getPrimaryItemName());
        ntt.setPrimaryItemName(this.jcrPrimaryType);
        NodeTypeCreationTest.assertEquals((String)this.jcrPrimaryType, (String)ntt.getPrimaryItemName());
        PropertyDefinitionTemplate pdTemplate = this.createBooleanPropTemplate();
        List pdefs = ntt.getPropertyDefinitionTemplates();
        pdefs.add(pdTemplate);
        NodeTypeCreationTest.assertNotNull((Object)ntt.getDeclaredPropertyDefinitions());
        NodeTypeCreationTest.assertEquals((int)1, (int)ntt.getDeclaredPropertyDefinitions().length);
        NodeTypeCreationTest.assertEquals((Object)pdTemplate, (Object)ntt.getDeclaredPropertyDefinitions()[0]);
        pdefs = ntt.getPropertyDefinitionTemplates();
        NodeTypeCreationTest.assertEquals((int)1, (int)pdefs.size());
        NodeTypeCreationTest.assertEquals((Object)pdTemplate, pdefs.get(0));
        NodeDefinitionTemplate ndTemplate = this.ntm.createNodeDefinitionTemplate();
        List ndefs = ntt.getNodeDefinitionTemplates();
        ndefs.add(ndTemplate);
        NodeTypeCreationTest.assertNotNull((Object)ntt.getDeclaredChildNodeDefinitions());
        NodeTypeCreationTest.assertEquals((int)1, (int)ntt.getDeclaredChildNodeDefinitions().length);
        NodeTypeCreationTest.assertEquals((Object)ndTemplate, (Object)ntt.getDeclaredChildNodeDefinitions()[0]);
        ndefs = ntt.getNodeDefinitionTemplates();
        NodeTypeCreationTest.assertEquals((int)1, (int)ndefs.size());
        NodeTypeCreationTest.assertEquals((Object)ndTemplate, ndefs.get(0));
    }

    public void testEmptyPropertyDefinitionTemplate() throws Exception {
        PropertyDefinitionTemplate pdt = this.ntm.createPropertyDefinitionTemplate();
        NodeTypeCreationTest.assertNull((Object)pdt.getName());
        NodeTypeCreationTest.assertFalse((boolean)pdt.isAutoCreated());
        NodeTypeCreationTest.assertFalse((boolean)pdt.isMandatory());
        NodeTypeCreationTest.assertFalse((boolean)pdt.isProtected());
        NodeTypeCreationTest.assertEquals((int)1, (int)pdt.getOnParentVersion());
        NodeTypeCreationTest.assertNull((Object)pdt.getDeclaringNodeType());
        NodeTypeCreationTest.assertEquals((int)1, (int)pdt.getRequiredType());
        NodeTypeCreationTest.assertFalse((boolean)pdt.isMultiple());
        NodeTypeCreationTest.assertNull((Object)pdt.getValueConstraints());
        NodeTypeCreationTest.assertNull((Object)pdt.getDefaultValues());
    }

    public void testPropertyDefinitionTemplate() throws Exception {
        PropertyDefinitionTemplate pdt = this.createBooleanPropTemplate();
        NodeTypeCreationTest.assertEquals((String)this.jcrPropName, (String)pdt.getName());
        try {
            pdt.setName(null);
            NodeTypeCreationTest.fail((String)"null isn't a valid JCR name");
        }
        catch (ConstraintViolationException e) {
            // empty catch block
        }
        NodeTypeCreationTest.assertEquals((boolean)false, (boolean)pdt.isAutoCreated());
        NodeTypeCreationTest.assertEquals((boolean)false, (boolean)pdt.isMandatory());
        NodeTypeCreationTest.assertEquals((int)5, (int)pdt.getOnParentVersion());
        NodeTypeCreationTest.assertEquals((boolean)false, (boolean)pdt.isProtected());
        NodeTypeCreationTest.assertEquals((int)6, (int)pdt.getRequiredType());
        NodeTypeCreationTest.assertEquals(null, (Object)pdt.getValueConstraints());
        NodeTypeCreationTest.assertEquals(null, (Object)pdt.getDefaultValues());
        NodeTypeCreationTest.assertEquals((boolean)false, (boolean)pdt.isMultiple());
        String[] qo = pdt.getAvailableQueryOperators();
        NodeTypeCreationTest.assertEquals((int)1, (int)qo.length);
        NodeTypeCreationTest.assertEquals((String)"jcr.operator.equal.to", (String)qo[0]);
        NodeTypeCreationTest.assertEquals((boolean)false, (boolean)pdt.isFullTextSearchable());
        NodeTypeCreationTest.assertEquals((boolean)false, (boolean)pdt.isQueryOrderable());
    }

    public void testSetDefaultValues() throws Exception {
        PropertyDefinitionTemplate pdt = this.ntm.createPropertyDefinitionTemplate();
        pdt.setRequiredType(3);
        pdt.setDefaultValues(null);
        NodeTypeCreationTest.assertNull((Object)pdt.getDefaultValues());
        pdt.setDefaultValues(new Value[0]);
        NodeTypeCreationTest.assertNotNull((Object)pdt.getDefaultValues());
        NodeTypeCreationTest.assertEquals((int)0, (int)pdt.getDefaultValues().length);
        pdt.setDefaultValues(new Value[]{this.superuser.getValueFactory().createValue(24L)});
        NodeTypeCreationTest.assertNotNull((Object)pdt.getDefaultValues());
        NodeTypeCreationTest.assertEquals((int)1, (int)pdt.getDefaultValues().length);
        NodeTypeCreationTest.assertEquals((long)24L, (long)pdt.getDefaultValues()[0].getLong());
        NodeTypeCreationTest.assertEquals((int)3, (int)pdt.getDefaultValues()[0].getType());
    }

    public void testEmptyNodeDefinitionTemplate() throws Exception {
        NodeDefinitionTemplate ndt = this.ntm.createNodeDefinitionTemplate();
        NodeTypeCreationTest.assertNull((Object)ndt.getName());
        NodeTypeCreationTest.assertFalse((boolean)ndt.isAutoCreated());
        NodeTypeCreationTest.assertFalse((boolean)ndt.isMandatory());
        NodeTypeCreationTest.assertFalse((boolean)ndt.isProtected());
        NodeTypeCreationTest.assertEquals((int)1, (int)ndt.getOnParentVersion());
        NodeTypeCreationTest.assertNull((Object)ndt.getDeclaringNodeType());
        NodeTypeCreationTest.assertNull((Object)ndt.getRequiredPrimaryTypes());
        NodeTypeCreationTest.assertNull((Object)ndt.getRequiredPrimaryTypeNames());
        NodeTypeCreationTest.assertNull((Object)ndt.getDefaultPrimaryType());
        NodeTypeCreationTest.assertNull((Object)ndt.getDefaultPrimaryTypeName());
        NodeTypeCreationTest.assertFalse((boolean)ndt.allowsSameNameSiblings());
    }

    public void testNodeDefinitionTemplate() throws Exception {
        NodeDefinitionTemplate ndt = this.ntm.createNodeDefinitionTemplate();
        try {
            ndt.setName(null);
            NodeTypeCreationTest.fail((String)"null isn't a valid JCR name");
        }
        catch (ConstraintViolationException e) {
            // empty catch block
        }
        String expandedName = "{http://www.jcp.org/jcr/1.0}content";
        String jcrName = this.superuser.getNamespacePrefix("http://www.jcp.org/jcr/1.0") + ":content";
        ndt.setName(expandedName);
        NodeTypeCreationTest.assertEquals((String)jcrName, (String)ndt.getName());
        ndt.setName(jcrName);
        NodeTypeCreationTest.assertEquals((String)jcrName, (String)ndt.getName());
        ndt.setSameNameSiblings(true);
        NodeTypeCreationTest.assertTrue((boolean)ndt.allowsSameNameSiblings());
        ndt.setAutoCreated(true);
        NodeTypeCreationTest.assertTrue((boolean)ndt.isAutoCreated());
        ndt.setMandatory(true);
        NodeTypeCreationTest.assertTrue((boolean)ndt.isMandatory());
        ndt.setProtected(true);
        NodeTypeCreationTest.assertTrue((boolean)ndt.isProtected());
        ndt.setOnParentVersion(2);
        NodeTypeCreationTest.assertEquals((int)2, (int)ndt.getOnParentVersion());
        expandedName = "{http://www.jcp.org/jcr/nt/1.0}folder";
        jcrName = this.superuser.getNamespacePrefix("http://www.jcp.org/jcr/nt/1.0") + ":folder";
        ndt.setDefaultPrimaryTypeName(expandedName);
        NodeTypeCreationTest.assertEquals((String)jcrName, (String)ndt.getDefaultPrimaryTypeName());
        ndt.setDefaultPrimaryTypeName(null);
        NodeTypeCreationTest.assertEquals((String)"setting null must clear the name.", null, (String)ndt.getDefaultPrimaryTypeName());
        ndt.setRequiredPrimaryTypeNames(new String[]{expandedName});
        NodeTypeCreationTest.assertNotNull((Object)ndt.getRequiredPrimaryTypeNames());
        NodeTypeCreationTest.assertEquals((int)1, (int)ndt.getRequiredPrimaryTypeNames().length);
        NodeTypeCreationTest.assertEquals((String)jcrName, (String)ndt.getRequiredPrimaryTypeNames()[0]);
        try {
            ndt.setRequiredPrimaryTypeNames(null);
            NodeTypeCreationTest.fail((String)"null isn't a valid array of jcr name");
        }
        catch (ConstraintViolationException e) {
            // empty catch block
        }
    }

    public void testResidualNames() throws Exception {
        String residualName = "*";
        NodeDefinitionTemplate ndt = this.ntm.createNodeDefinitionTemplate();
        ndt.setName(residualName);
        NodeTypeCreationTest.assertEquals((String)residualName, (String)ndt.getName());
        PropertyDefinitionTemplate pdt = this.ntm.createPropertyDefinitionTemplate();
        pdt.setName(residualName);
        NodeTypeCreationTest.assertEquals((String)residualName, (String)pdt.getName());
    }

    public void testInvalidJCRNames() throws Exception {
        String invalidName = ":ab[2]";
        NodeTypeTemplate ntt = this.ntm.createNodeTypeTemplate();
        try {
            ntt.setName(invalidName);
            NodeTypeCreationTest.fail((String)"ConstraintViolationException expected. Nt-name is invalid");
        }
        catch (ConstraintViolationException e) {
            // empty catch block
        }
        try {
            ntt.setDeclaredSuperTypeNames(new String[]{"{http://www.jcp.org/jcr/mix/1.0}littlemixin", invalidName});
            NodeTypeCreationTest.fail((String)"ConstraintViolationException expected. One of the super type names is invalid");
        }
        catch (ConstraintViolationException e) {
            // empty catch block
        }
        try {
            ntt.setPrimaryItemName(invalidName);
            NodeTypeCreationTest.fail((String)"ConstraintViolationException expected. Primary item name is invalid");
        }
        catch (ConstraintViolationException e) {
            // empty catch block
        }
        NodeDefinitionTemplate ndt = this.ntm.createNodeDefinitionTemplate();
        try {
            ndt.setName(invalidName);
            NodeTypeCreationTest.fail((String)"ConstraintViolationException expected. Name is invalid");
        }
        catch (ConstraintViolationException e) {
            // empty catch block
        }
        try {
            ndt.setRequiredPrimaryTypeNames(new String[]{"{http://www.jcp.org/jcr/mix/1.0}littlemixin", invalidName});
            NodeTypeCreationTest.fail((String)"ConstraintViolationException expected. One of the required primary type names is invalid");
        }
        catch (ConstraintViolationException e) {
            // empty catch block
        }
        try {
            ndt.setDefaultPrimaryTypeName(invalidName);
            NodeTypeCreationTest.fail((String)"ConstraintViolationException expected. Default primary type name is invalid");
        }
        catch (ConstraintViolationException e) {
            // empty catch block
        }
        PropertyDefinitionTemplate pdt = this.ntm.createPropertyDefinitionTemplate();
        try {
            pdt.setName(invalidName);
            NodeTypeCreationTest.fail((String)"ConstraintViolationException expected. Name is invalid");
        }
        catch (ConstraintViolationException e) {
            // empty catch block
        }
    }

    public void testRegisterNodeType() throws Exception {
        NodeTypeTemplate ntt = this.ntm.createNodeTypeTemplate();
        ntt.setName("mix:foo");
        ntt.setAbstract(false);
        ntt.setMixin(true);
        ntt.setOrderableChildNodes(false);
        ntt.setQueryable(false);
        PropertyDefinitionTemplate pdt = this.ntm.createPropertyDefinitionTemplate();
        pdt.setAutoCreated(false);
        pdt.setName("foo");
        pdt.setMultiple(false);
        pdt.setRequiredType(1);
        List pdefs = ntt.getPropertyDefinitionTemplates();
        pdefs.add(pdt);
        this.ntm.registerNodeType((NodeTypeDefinition)ntt, true);
        try {
            this.ntm.registerNodeType((NodeTypeDefinition)ntt, false);
            NodeTypeCreationTest.fail((String)"NodeTypeExistsException expected.");
        }
        catch (NodeTypeExistsException e) {
            // empty catch block
        }
    }

    public void testUnregisterNodeType() throws Exception {
        try {
            this.ntm.unregisterNodeType("unknownnodetype");
            NodeTypeCreationTest.fail((String)"NoSuchNodeTypeException expected.");
        }
        catch (NoSuchNodeTypeException e) {
            // empty catch block
        }
        try {
            this.ntm.unregisterNodeType("nt:base");
            NodeTypeCreationTest.fail((String)"RepositoryException expected.");
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public void testUnregisterNodeTypes() throws Exception {
        try {
            this.ntm.unregisterNodeTypes(new String[]{"unknownnodetype1", "unknownnodetype2"});
            NodeTypeCreationTest.fail((String)"NoSuchNodeTypeException expected.");
        }
        catch (NoSuchNodeTypeException e) {
            // empty catch block
        }
        try {
            this.ntm.unregisterNodeTypes(new String[]{"nt:base", "nt:address"});
            NodeTypeCreationTest.fail((String)"RepositoryException expected.");
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    public void testRegisterNodeTypes() throws Exception {
        NodeTypeDefinition[] defs = new NodeTypeDefinition[5];
        for (int i = 0; i < defs.length; ++i) {
            NodeTypeTemplate ntt = this.ntm.createNodeTypeTemplate();
            ntt.setName("mix:foo" + i);
            ntt.setAbstract(false);
            ntt.setMixin(true);
            ntt.setOrderableChildNodes(false);
            ntt.setQueryable(false);
            PropertyDefinitionTemplate pdt = this.ntm.createPropertyDefinitionTemplate();
            pdt.setAutoCreated(false);
            pdt.setName("foo" + i);
            pdt.setMultiple(false);
            pdt.setRequiredType(1);
            List pdefs = ntt.getPropertyDefinitionTemplates();
            pdefs.add(pdt);
            defs[i] = ntt;
        }
        this.ntm.registerNodeTypes(defs, true);
        try {
            this.ntm.registerNodeTypes(defs, false);
            NodeTypeCreationTest.fail((String)"NodeTypeExistsException expected.");
        }
        catch (NodeTypeExistsException nodeTypeExistsException) {
            // empty catch block
        }
    }

    private PropertyDefinitionTemplate createBooleanPropTemplate() throws RepositoryException {
        PropertyDefinitionTemplate pdt = this.ntm.createPropertyDefinitionTemplate();
        pdt.setName(this.expandedPropName);
        pdt.setAutoCreated(false);
        pdt.setMandatory(false);
        pdt.setOnParentVersion(5);
        pdt.setProtected(false);
        pdt.setRequiredType(6);
        pdt.setValueConstraints(null);
        pdt.setDefaultValues(null);
        pdt.setMultiple(false);
        pdt.setAvailableQueryOperators(new String[]{"jcr.operator.equal.to"});
        pdt.setFullTextSearchable(false);
        pdt.setQueryOrderable(false);
        return pdt;
    }
}

