/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2davex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.commons.json.JsonHandler;
import org.apache.jackrabbit.spi.IdFactory;
import org.apache.jackrabbit.spi.ItemInfo;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.NodeInfo;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PathFactory;
import org.apache.jackrabbit.spi.PropertyId;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.util.StringCache;
import org.apache.jackrabbit.spi2davex.ChildInfoImpl;
import org.apache.jackrabbit.spi2davex.NodeInfoImpl;
import org.apache.jackrabbit.spi2davex.PropertyInfoImpl;
import org.apache.jackrabbit.spi2davex.QValueFactoryImpl;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ItemInfoJsonHandler
implements JsonHandler {
    private static Logger log = LoggerFactory.getLogger(ItemInfoJsonHandler.class);
    private static final String LEAF_NODE_HINT = "::NodeIteratorSize";
    private final List<ItemInfo> itemInfos;
    private final NamePathResolver resolver;
    private final String rootURI;
    private final QValueFactoryImpl vFactory;
    private final PathFactory pFactory;
    private final IdFactory idFactory;
    private boolean expectingHintValue = false;
    private Name name;
    private int index = 1;
    private int propertyType;
    private boolean multiValuedProperty = false;
    private List<QValue> propValues = new ArrayList<QValue>();
    private Stack<NodeInfo> nodeInfos = new Stack();
    private Stack<List<PropertyInfoImpl>> propInfoLists = new Stack();

    ItemInfoJsonHandler(NamePathResolver resolver, NodeInfo nInfo, String rootURI, QValueFactoryImpl vFactory, PathFactory pFactory, IdFactory idFactory) {
        this.resolver = resolver;
        this.rootURI = rootURI;
        this.vFactory = vFactory;
        this.pFactory = pFactory;
        this.idFactory = idFactory;
        this.itemInfos = new ArrayList<ItemInfo>();
        this.itemInfos.add((ItemInfo)nInfo);
        this.nodeInfos.push(nInfo);
        this.propInfoLists.push(new ArrayList(8));
    }

    public void object() throws IOException {
        if (this.name != null) {
            try {
                NodeInfoImpl current = this.getCurrentNodeInfo();
                Path relPath = this.pFactory.create(this.name, this.index);
                NodeId id = this.idFactory.createNodeId(current.getId(), relPath);
                Path currentPath = current.getPath();
                Path p = this.pFactory.create(currentPath, relPath, true);
                NodeInfoImpl nInfo = new NodeInfoImpl(id, p);
                this.nodeInfos.push(nInfo);
                this.propInfoLists.push(new ArrayList(8));
            }
            catch (RepositoryException e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    public void endObject() throws IOException {
        try {
            NodeInfoImpl nInfo = (NodeInfoImpl)this.nodeInfos.pop();
            List<PropertyInfoImpl> props = this.propInfoLists.pop();
            nInfo.setPropertyInfos(props.toArray(new PropertyInfoImpl[props.size()]), this.idFactory);
            NodeInfoImpl parent = this.getCurrentNodeInfo();
            if (parent != null) {
                if (nInfo.getPath().getAncestor(1).equals(parent.getPath())) {
                    ChildInfoImpl ci = new ChildInfoImpl(nInfo.getName(), nInfo.getUniqueID(), nInfo.getIndex());
                    parent.addChildInfo(ci);
                } else {
                    log.debug("NodeInfo '" + nInfo.getPath() + "' out of hierarchy. Parent path = " + parent.getPath());
                }
            }
            if (nInfo.isCompleted()) {
                this.itemInfos.addAll(props);
                this.itemInfos.add(nInfo);
            } else {
                log.debug("Incomplete NodeInfo '" + nInfo.getPath() + "' -> Only present as ChildInfo with its parent.");
            }
        }
        catch (RepositoryException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            this.name = null;
            this.index = 1;
        }
    }

    public void array() throws IOException {
        this.multiValuedProperty = true;
        this.propValues.clear();
    }

    public void endArray() throws IOException {
        try {
            if (this.propertyType == 0) {
                this.propertyType = this.propValues.isEmpty() ? this.vFactory.retrieveType(this.getValueURI()) : this.propValues.get(0).getType();
            }
            NodeInfoImpl parent = this.getCurrentNodeInfo();
            Path p = this.pFactory.create(parent.getPath(), this.name, true);
            PropertyId id = this.idFactory.createPropertyId(parent.getId(), this.name);
            PropertyInfoImpl propInfo = new PropertyInfoImpl(id, p, this.propertyType, this.propValues.toArray(new QValue[this.propValues.size()]));
            propInfo.checkCompleted();
            this.getCurrentPropInfos().add(propInfo);
        }
        catch (RepositoryException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            this.propertyType = 0;
            this.multiValuedProperty = false;
            this.propValues.clear();
            this.name = null;
        }
    }

    public void key(String key) throws IOException {
        this.expectingHintValue = false;
        try {
            if (key.equals(LEAF_NODE_HINT)) {
                this.expectingHintValue = true;
                this.name = null;
            } else if (key.startsWith(":")) {
                this.expectingHintValue = true;
                this.name = this.resolver.getQName(StringCache.fromCacheOrNew((String)key.substring(1)));
                this.index = 1;
            } else if (key.endsWith("]")) {
                int pos = key.lastIndexOf(91);
                this.name = this.resolver.getQName(StringCache.fromCacheOrNew((String)key.substring(0, pos)));
                this.propertyType = 0;
                this.index = Integer.parseInt(key.substring(pos + 1, key.length() - 1));
            } else {
                this.name = this.resolver.getQName(StringCache.cache((String)key));
                this.index = 1;
            }
        }
        catch (RepositoryException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void value(String value) throws IOException {
        if (this.expectingHintValue) {
            this.propertyType = PropertyType.valueFromName((String)value);
            return;
        }
        try {
            QValue v;
            switch (this.propertyType) {
                case 0: {
                    if (!NameConstants.JCR_UUID.equals(this.name)) {
                        value = StringCache.cache((String)value);
                    }
                    v = this.vFactory.create(value, 1);
                    break;
                }
                case 7: {
                    v = this.vFactory.create(this.resolver.getQName(value));
                    break;
                }
                case 8: {
                    v = this.vFactory.create(this.resolver.getQPath(value));
                    break;
                }
                default: {
                    v = this.vFactory.create(value, this.propertyType);
                }
            }
            this.value(v);
        }
        catch (RepositoryException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void value(boolean value) throws IOException {
        if (this.expectingHintValue) {
            return;
        }
        try {
            this.value(this.vFactory.create(value));
        }
        catch (RepositoryException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void value(long value) throws IOException {
        if (this.expectingHintValue) {
            if (this.name == null) {
                NodeInfoImpl parent = this.getCurrentNodeInfo();
                if (parent != null) {
                    parent.markAsLeafNode();
                }
            } else {
                this.propertyType = 2;
                try {
                    int indx = !this.multiValuedProperty ? -1 : this.propValues.size();
                    this.value(this.vFactory.create(value, this.getValueURI(), indx));
                }
                catch (RepositoryException e) {
                    throw new IOException(e.getMessage());
                }
            }
            return;
        }
        try {
            this.value(this.vFactory.create(value));
        }
        catch (RepositoryException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void value(double value) throws IOException {
        if (this.expectingHintValue) {
            return;
        }
        try {
            this.value(this.vFactory.create(value));
        }
        catch (RepositoryException e) {
            throw new IOException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void value(QValue value) throws RepositoryException {
        if (!this.multiValuedProperty) {
            try {
                if (this.propertyType == 0) {
                    this.propertyType = value.getType();
                }
                NodeInfoImpl parent = this.getCurrentNodeInfo();
                Path p = this.pFactory.create(parent.getPath(), this.name, true);
                PropertyId id = this.idFactory.createPropertyId(parent.getId(), this.name);
                PropertyInfoImpl propInfo = new PropertyInfoImpl(id, p, this.propertyType, value);
                propInfo.checkCompleted();
                this.getCurrentPropInfos().add(propInfo);
            }
            finally {
                this.propertyType = 0;
                this.multiValuedProperty = false;
                this.propValues.clear();
                this.name = null;
                this.expectingHintValue = false;
            }
        } else {
            this.propValues.add(value);
        }
    }

    Iterator<? extends ItemInfo> getItemInfos() {
        return Collections.unmodifiableList(this.itemInfos).iterator();
    }

    private NodeInfoImpl getCurrentNodeInfo() {
        return this.nodeInfos.isEmpty() ? null : (NodeInfoImpl)this.nodeInfos.peek();
    }

    private List<PropertyInfoImpl> getCurrentPropInfos() {
        return this.propInfoLists.isEmpty() ? null : this.propInfoLists.peek();
    }

    private String getValueURI() throws RepositoryException {
        Path propertyPath = this.pFactory.create(this.getCurrentNodeInfo().getPath(), this.name, true);
        StringBuffer sb = new StringBuffer(this.rootURI);
        sb.append(Text.escapePath((String)this.resolver.getJCRPath(propertyPath)));
        return sb.toString();
    }
}

