/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.client.methods;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class XmlRequestEntity
implements RequestEntity {
    private static Logger log = LoggerFactory.getLogger((Class)XmlRequestEntity.class);
    private final RequestEntity delegatee;

    public XmlRequestEntity(Document xmlDocument) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        OutputFormat format = new OutputFormat("xml", "UTF-8", false);
        XMLSerializer serializer = new XMLSerializer((OutputStream)out, format);
        serializer.setNamespaces(true);
        serializer.asDOMSerializer().serialize(xmlDocument);
        this.delegatee = new StringRequestEntity(out.toString(), "text/xml", "UTF-8");
    }

    public boolean isRepeatable() {
        return this.delegatee.isRepeatable();
    }

    public String getContentType() {
        return this.delegatee.getContentType();
    }

    public void writeRequest(OutputStream out) throws IOException {
        this.delegatee.writeRequest(out);
    }

    public long getContentLength() {
        return this.delegatee.getContentLength();
    }
}

