/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.client.methods;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jackrabbit.webdav.client.methods.DavMethodBase;
import org.apache.jackrabbit.webdav.version.DeltaVConstants;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BaselineControlMethod
extends DavMethodBase {
    public BaselineControlMethod(String uri) {
        super(uri);
    }

    public BaselineControlMethod(String uri, String baselineHref) throws IOException {
        super(uri);
        if (baselineHref != null) {
            try {
                Document document = DomUtil.createDocument();
                Element el = DomUtil.addChildElement(document, "baseline-control", DeltaVConstants.NAMESPACE);
                el.appendChild(DomUtil.hrefToXml(baselineHref, document));
                this.setRequestBody(document);
            }
            catch (ParserConfigurationException e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    @Override
    public String getName() {
        return "BASELINE-CONTROL";
    }

    @Override
    protected boolean isSuccess(int statusCode) {
        return statusCode == 200;
    }
}

