/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.byon;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.jclouds.ContextBuilder;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.byon.BYONApiMetadata;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.options.RunScriptOptions;
import org.jclouds.logging.log4j.config.Log4JLoggingModule;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.Statements;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"live"})
public class BYONComputeServiceLiveTest {
    private ComputeServiceContext context;

    @BeforeClass(groups={"live"})
    public void setup() throws FileNotFoundException, IOException {
        Properties contextProperties = new Properties();
        StringBuilder nodes = new StringBuilder();
        nodes.append("nodes:\n");
        nodes.append("    - id: mymachine\n");
        nodes.append("      name: my local machine\n");
        nodes.append("      hostname: localhost\n");
        nodes.append("      os_arch: ").append(System.getProperty("os.arch")).append("\n");
        nodes.append("      os_family: ").append(OsFamily.UNIX).append("\n");
        nodes.append("      os_description: ").append(System.getProperty("os.name")).append("\n");
        nodes.append("      os_version: ").append(System.getProperty("os.version")).append("\n");
        nodes.append("      group: ").append("ssh").append("\n");
        nodes.append("      tags:\n");
        nodes.append("          - local\n");
        nodes.append("      username: ").append(System.getProperty("user.name")).append("\n");
        nodes.append("      credential_url: file://").append(System.getProperty("user.home")).append("/.ssh/id_rsa").append("\n");
        contextProperties.setProperty("byon.nodes", nodes.toString());
        this.context = (ComputeServiceContext)ContextBuilder.newBuilder((ApiMetadata)new BYONApiMetadata()).overrides(contextProperties).modules((Iterable)ImmutableSet.of((Object)new SshjSshClientModule(), (Object)new Log4JLoggingModule())).build(ComputeServiceContext.class);
    }

    public void testCanRunCommandAsCurrentUser() throws Exception {
        Map responses = this.context.getComputeService().runScriptOnNodesMatching(Predicates.alwaysTrue(), Statements.exec((String)"id"), RunScriptOptions.Builder.wrapInInitScript((boolean)false).runAsRoot(false));
        for (Map.Entry response : responses.entrySet()) {
            assert (((ExecResponse)response.getValue()).getOutput().trim().contains(System.getProperty("user.name"))) : response.getKey() + ": " + response.getValue();
        }
    }

    @AfterClass(groups={"live"})
    public void close() throws FileNotFoundException, IOException {
        if (this.context != null) {
            this.context.close();
        }
    }
}

