/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.Date;
import org.jclouds.cloudservers.domain.ImageStatus;
import org.jclouds.javax.annotation.Nullable;

public class Image {
    private final Date created;
    private final int id;
    private final String name;
    private final Integer progress;
    private final Integer serverId;
    private final ImageStatus status;
    private final Date updated;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromImage(this);
    }

    @ConstructorProperties(value={"created", "id", "name", "progress", "serverId", "status", "updated"})
    protected Image(@Nullable Date created, int id, String name, @Nullable Integer progress, @Nullable Integer serverId, @Nullable ImageStatus status, @Nullable Date updated) {
        this.created = created;
        this.id = id;
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
        this.progress = progress;
        this.serverId = serverId;
        this.status = status;
        this.updated = updated;
    }

    @Nullable
    public Date getCreated() {
        return this.created;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public Integer getProgress() {
        return this.progress;
    }

    @Nullable
    public Integer getServerId() {
        return this.serverId;
    }

    @Nullable
    public ImageStatus getStatus() {
        return this.status;
    }

    @Nullable
    public Date getUpdated() {
        return this.updated;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.created, this.id, this.name, this.progress, this.serverId, this.status, this.updated});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Image that = (Image)Image.class.cast(obj);
        return Objects.equal((Object)this.created, (Object)that.created) && Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.progress, (Object)that.progress) && Objects.equal((Object)this.serverId, (Object)that.serverId) && Objects.equal((Object)((Object)this.status), (Object)((Object)that.status)) && Objects.equal((Object)this.updated, (Object)that.updated);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("created", (Object)this.created).add("id", this.id).add("name", (Object)this.name).add("progress", (Object)this.progress).add("serverId", (Object)this.serverId).add("status", (Object)this.status).add("updated", (Object)this.updated);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected Date created;
        protected int id;
        protected String name;
        protected Integer progress;
        protected Integer serverId;
        protected ImageStatus status;
        protected Date updated;

        protected abstract T self();

        public T created(Date created) {
            this.created = created;
            return this.self();
        }

        public T id(int id) {
            this.id = id;
            return this.self();
        }

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T progress(Integer progress) {
            this.progress = progress;
            return this.self();
        }

        public T serverId(Integer serverId) {
            this.serverId = serverId;
            return this.self();
        }

        public T status(ImageStatus status) {
            this.status = status;
            return this.self();
        }

        public T updated(Date updated) {
            this.updated = updated;
            return this.self();
        }

        public Image build() {
            return new Image(this.created, this.id, this.name, this.progress, this.serverId, this.status, this.updated);
        }

        public T fromImage(Image in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.created(in.getCreated())).id(in.getId())).name(in.getName())).progress(in.getProgress())).serverId(in.getServerId())).status(in.getStatus())).updated(in.getUpdated());
        }
    }
}

