/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jclouds.cloudservers.domain.RateLimit;

public class Limits {
    private final Set<RateLimit> rate;
    private final Map<String, Integer> absolute;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromLimits(this);
    }

    @ConstructorProperties(value={"rate", "absolute"})
    protected Limits(Set<RateLimit> rate, Map<String, Integer> absolute) {
        this.rate = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(rate, (Object)"rate")));
        this.absolute = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(absolute, (Object)"absolute")));
    }

    public Set<RateLimit> getRate() {
        return this.rate;
    }

    public Map<String, Integer> getAbsolute() {
        return this.absolute;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.rate, this.absolute});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Limits that = (Limits)Limits.class.cast(obj);
        return Objects.equal(this.rate, that.rate) && Objects.equal(this.absolute, that.absolute);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("rate", this.rate).add("absolute", this.absolute);
    }

    public String toString() {
        return this.string().toString();
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected Set<RateLimit> rate = ImmutableSet.of();
        protected Map<String, Integer> absolute = ImmutableMap.of();

        protected abstract T self();

        public T rate(Set<RateLimit> rate) {
            this.rate = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(rate, (Object)"rate")));
            return this.self();
        }

        public T rate(RateLimit ... in) {
            return this.rate((Set<RateLimit>)ImmutableSet.copyOf((Object[])in));
        }

        public T absolute(Map<String, Integer> absolute) {
            this.absolute = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(absolute, (Object)"absolute")));
            return this.self();
        }

        public Limits build() {
            return new Limits(this.rate, this.absolute);
        }

        public T fromLimits(Limits in) {
            return ((Builder)this.rate(in.getRate())).absolute(in.getAbsolute());
        }
    }
}

