/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.BaseEncoding;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.cloudservers.domain.Addresses;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToJsonPayload;

public class CreateServerOptions
implements MapBinder {
    @Inject
    private BindToJsonPayload jsonBinder;
    private Map<String, String> metadata = Maps.newHashMap();
    private List<File> files = Lists.newArrayList();
    private Integer sharedIpGroupId;
    private String publicIp;

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        ServerRequest server = new ServerRequest(Preconditions.checkNotNull((Object)postParams.get("name"), (Object)"name parameter not present").toString(), Integer.parseInt(Preconditions.checkNotNull((Object)postParams.get("imageId"), (Object)"imageId parameter not present").toString()), Integer.parseInt(Preconditions.checkNotNull((Object)postParams.get("flavorId"), (Object)"flavorId parameter not present").toString()));
        if (!this.metadata.isEmpty()) {
            server.metadata = this.metadata;
        }
        if (!this.files.isEmpty()) {
            server.personality = this.files;
        }
        if (this.sharedIpGroupId != null) {
            server.sharedIpGroupId = this.sharedIpGroupId;
        }
        if (this.publicIp != null) {
            server.addresses = ((Addresses.Builder)Addresses.builder().publicAddresses((Collection<String>)ImmutableSet.of((Object)this.publicIp))).build();
        }
        return this.bindToRequest(request, ImmutableMap.of((Object)"server", (Object)server));
    }

    public CreateServerOptions withFile(String path, byte[] contents) {
        Preconditions.checkState((this.files.size() < 5 ? 1 : 0) != 0, (Object)"maximum number of files allowed is 5");
        this.files.add(new File(path, contents));
        return this;
    }

    public CreateServerOptions withSharedIpGroup(int id) {
        Preconditions.checkArgument((id > 0 ? 1 : 0) != 0, (Object)("id must be positive or zero.  was: " + id));
        this.sharedIpGroupId = id;
        return this;
    }

    public CreateServerOptions withMetadata(Map<String, String> metadata) {
        Preconditions.checkNotNull(metadata, (Object)"metadata");
        Preconditions.checkArgument((metadata.size() <= 5 ? 1 : 0) != 0, (Object)("you cannot have more then 5 metadata values.  You specified: " + metadata.size()));
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            Preconditions.checkArgument((entry.getKey().getBytes().length < 255 ? 1 : 0) != 0, (Object)String.format("maximum length of metadata key is 255 bytes.  Key specified %s is %d bytes", entry.getKey(), entry.getKey().getBytes().length));
            Preconditions.checkArgument((entry.getKey().getBytes().length < 255 ? 1 : 0) != 0, (Object)String.format("maximum length of metadata value is 255 bytes.  Value specified for %s (%s) is %d bytes", entry.getKey(), entry.getValue(), entry.getValue().getBytes().length));
        }
        this.metadata = metadata;
        return this;
    }

    public CreateServerOptions withSharedIp(String publicIp) {
        Preconditions.checkState((this.sharedIpGroupId != null ? 1 : 0) != 0, (Object)"sharedIp is invalid unless a shared ip group is specified.");
        this.publicIp = (String)Preconditions.checkNotNull((Object)publicIp, (Object)"ip");
        return this;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        return (R)this.jsonBinder.bindToRequest(request, input);
    }

    public static class Builder {
        public static CreateServerOptions withFile(String path, byte[] contents) {
            CreateServerOptions options = new CreateServerOptions();
            return options.withFile(path, contents);
        }

        public static CreateServerOptions withSharedIpGroup(int id) {
            CreateServerOptions options = new CreateServerOptions();
            return options.withSharedIpGroup(id);
        }

        public static CreateServerOptions withMetadata(Map<String, String> metadata) {
            CreateServerOptions options = new CreateServerOptions();
            return options.withMetadata(metadata);
        }

        public static CreateServerOptions withSharedIp(String publicIp) {
            CreateServerOptions options = new CreateServerOptions();
            return options.withSharedIp(publicIp);
        }
    }

    private static class ServerRequest {
        final String name;
        final int imageId;
        final int flavorId;
        Map<String, String> metadata;
        List<File> personality;
        Integer sharedIpGroupId;
        Addresses addresses;

        private ServerRequest(String name, int imageId, int flavorId) {
            this.name = name;
            this.imageId = imageId;
            this.flavorId = flavorId;
        }
    }

    static class File {
        private final String path;
        private final String contents;

        public File(String path, byte[] contents) {
            this.path = (String)Preconditions.checkNotNull((Object)path, (Object)"path");
            this.contents = BaseEncoding.base64().encode((byte[])Preconditions.checkNotNull((Object)contents, (Object)"contents"));
            Preconditions.checkArgument((path.getBytes().length < 255 ? 1 : 0) != 0, (Object)String.format("maximum length of path is 255 bytes.  Path specified %s is %d bytes", path, path.getBytes().length));
            Preconditions.checkArgument((contents.length < 10240 ? 1 : 0) != 0, (Object)String.format("maximum size of the file is 10KB.  Contents specified is %d bytes", contents.length));
        }

        public String getContents() {
            return this.contents;
        }

        public String getPath() {
            return this.path;
        }
    }
}

