/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.reflect.Invokable;
import java.io.IOException;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.cloudsigma.CloudSigmaApiMetadata;
import org.jclouds.cloudsigma.CloudSigmaAsyncClient;
import org.jclouds.cloudsigma.binders.BindServerToPlainTextStringTest;
import org.jclouds.cloudsigma.domain.CreateDriveRequest;
import org.jclouds.cloudsigma.domain.Drive;
import org.jclouds.cloudsigma.domain.DriveData;
import org.jclouds.cloudsigma.domain.Server;
import org.jclouds.cloudsigma.functions.KeyValuesDelimitedByBlankLinesToDriveInfo;
import org.jclouds.cloudsigma.functions.KeyValuesDelimitedByBlankLinesToProfileInfo;
import org.jclouds.cloudsigma.functions.KeyValuesDelimitedByBlankLinesToServerInfo;
import org.jclouds.cloudsigma.functions.KeyValuesDelimitedByBlankLinesToStaticIPInfo;
import org.jclouds.cloudsigma.functions.KeyValuesDelimitedByBlankLinesToVLANInfo;
import org.jclouds.cloudsigma.functions.ListOfKeyValuesDelimitedByBlankLinesToDriveInfoSet;
import org.jclouds.cloudsigma.functions.ListOfKeyValuesDelimitedByBlankLinesToServerInfoSet;
import org.jclouds.cloudsigma.functions.ListOfKeyValuesDelimitedByBlankLinesToStaticIPInfoSet;
import org.jclouds.cloudsigma.functions.ListOfKeyValuesDelimitedByBlankLinesToVLANInfoSet;
import org.jclouds.cloudsigma.functions.SplitNewlines;
import org.jclouds.cloudsigma.functions.SplitNewlinesAndReturnSecondField;
import org.jclouds.cloudsigma.options.CloneDriveOptions;
import org.jclouds.fallbacks.MapHttp4xxCodesToExceptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.filters.BasicAuthentication;
import org.jclouds.http.functions.ReleasePayloadAndReturn;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.BaseAsyncClientTest;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="CloudSigmaAsyncClientTest")
public class CloudSigmaAsyncClientTest
extends BaseAsyncClientTest<CloudSigmaAsyncClient> {
    public void testGetProfileInfo() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(CloudSigmaAsyncClient.class, (String)"getProfileInfo", (Class[])new Class[0]);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of());
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/profile/info HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, KeyValuesDelimitedByBlankLinesToProfileInfo.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListStandardDrives() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(CloudSigmaAsyncClient.class, (String)"listStandardDrives", (Class[])new Class[0]);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of());
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/drives/standard/list HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, SplitNewlines.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListStandardCds() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(CloudSigmaAsyncClient.class, (String)"listStandardCds", (Class[])new Class[0]);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of());
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/drives/standard/cd/list HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, SplitNewlines.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListStandardImages() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(CloudSigmaAsyncClient.class, (String)"listStandardImages", (Class[])new Class[0]);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of());
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/drives/standard/img/list HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, SplitNewlines.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListDriveInfo() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(CloudSigmaAsyncClient.class, (String)"listDriveInfo", (Class[])new Class[0]);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of());
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/drives/info HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ListOfKeyValuesDelimitedByBlankLinesToDriveInfoSet.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testGetDriveInfo() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(CloudSigmaAsyncClient.class, (String)"getDriveInfo", (Class[])new Class[]{String.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"uuid"));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/drives/uuid/info HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, KeyValuesDelimitedByBlankLinesToDriveInfo.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testCreateDrive() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(CloudSigmaAsyncClient.class, (String)"createDrive", (Class[])new Class[]{Drive.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)new CreateDriveRequest.Builder().name("foo").use((Iterable)ImmutableList.of((Object)"production", (Object)"candy")).size(10000L).build()));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api.cloudsigma.com/drives/create HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, "name foo\nsize 10000\nuse production candy", "text/plain", false);
        this.assertResponseParserClassEquals(method, httpRequest, KeyValuesDelimitedByBlankLinesToDriveInfo.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testCloneDrive() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(CloudSigmaAsyncClient.class, (String)"cloneDrive", (Class[])new Class[]{String.class, String.class, CloneDriveOptions[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"sourceid", (Object)"newname"));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api.cloudsigma.com/drives/sourceid/clone HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, "name newname", "text/plain", false);
        this.assertResponseParserClassEquals(method, httpRequest, KeyValuesDelimitedByBlankLinesToDriveInfo.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testCloneDriveOptions() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(CloudSigmaAsyncClient.class, (String)"cloneDrive", (Class[])new Class[]{String.class, String.class, CloneDriveOptions[].class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"sourceid", (Object)"newname", (Object)new CloneDriveOptions().size(1024L)));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api.cloudsigma.com/drives/sourceid/clone HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, "name newname\nsize 1024", "text/plain", false);
        this.assertResponseParserClassEquals(method, httpRequest, KeyValuesDelimitedByBlankLinesToDriveInfo.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testSetDriveData() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(CloudSigmaAsyncClient.class, (String)"setDriveData", (Class[])new Class[]{String.class, DriveData.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"100", (Object)new DriveData.Builder().name("foo").size(10000L).use((Iterable)ImmutableList.of((Object)"production", (Object)"candy")).build()));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api.cloudsigma.com/drives/100/set HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, "name foo\nsize 10000\nuse production candy", "text/plain", false);
        this.assertResponseParserClassEquals(method, httpRequest, KeyValuesDelimitedByBlankLinesToDriveInfo.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListServers() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(CloudSigmaAsyncClient.class, (String)"listServers", (Class[])new Class[0]);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of());
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/servers/list HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        httpRequest = (GeneratedHttpRequest)((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        httpRequest = (GeneratedHttpRequest)((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/servers/list HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\nAuthorization: Basic aWRlbnRpdHk6Y3JlZGVudGlhbA==\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, SplitNewlines.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListServerInfo() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(CloudSigmaAsyncClient.class, (String)"listServerInfo", (Class[])new Class[0]);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of());
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/servers/info HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ListOfKeyValuesDelimitedByBlankLinesToServerInfoSet.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testGetServerInfo() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(CloudSigmaAsyncClient.class, (String)"getServerInfo", (Class[])new Class[]{String.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"uuid"));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/servers/uuid/info HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, KeyValuesDelimitedByBlankLinesToServerInfo.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testCreateServer() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(CloudSigmaAsyncClient.class, (String)"createServer", (Class[])new Class[]{Server.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)BindServerToPlainTextStringTest.SERVER));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api.cloudsigma.com/servers/create HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, BindServerToPlainTextStringTest.CREATED_SERVER, "text/plain", false);
        this.assertResponseParserClassEquals(method, httpRequest, KeyValuesDelimitedByBlankLinesToServerInfo.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testSetServerConfiguration() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(CloudSigmaAsyncClient.class, (String)"setServerConfiguration", (Class[])new Class[]{String.class, Server.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"100", (Object)BindServerToPlainTextStringTest.SERVER));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api.cloudsigma.com/servers/100/set HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, BindServerToPlainTextStringTest.CREATED_SERVER, "text/plain", false);
        this.assertResponseParserClassEquals(method, httpRequest, KeyValuesDelimitedByBlankLinesToServerInfo.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testDestroyServer() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(CloudSigmaAsyncClient.class, (String)"destroyServer", (Class[])new Class[]{String.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"uuid"));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/servers/uuid/destroy HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.VoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testStartServer() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(CloudSigmaAsyncClient.class, (String)"startServer", (Class[])new Class[]{String.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"uuid"));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api.cloudsigma.com/servers/uuid/start HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testStopServer() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(CloudSigmaAsyncClient.class, (String)"stopServer", (Class[])new Class[]{String.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"uuid"));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api.cloudsigma.com/servers/uuid/stop HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testShutdownServer() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(CloudSigmaAsyncClient.class, (String)"shutdownServer", (Class[])new Class[]{String.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"uuid"));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api.cloudsigma.com/servers/uuid/shutdown HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testResetServer() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(CloudSigmaAsyncClient.class, (String)"resetServer", (Class[])new Class[]{String.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"uuid"));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api.cloudsigma.com/servers/uuid/reset HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListDrives() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(CloudSigmaAsyncClient.class, (String)"listDrives", (Class[])new Class[0]);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of());
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/drives/list HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        httpRequest = (GeneratedHttpRequest)((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        httpRequest = (GeneratedHttpRequest)((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/drives/list HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\nAuthorization: Basic aWRlbnRpdHk6Y3JlZGVudGlhbA==\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, SplitNewlines.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testDestroyDrive() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(CloudSigmaAsyncClient.class, (String)"destroyDrive", (Class[])new Class[]{String.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"uuid"));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/drives/uuid/destroy HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.VoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListVLANs() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(CloudSigmaAsyncClient.class, (String)"listVLANs", (Class[])new Class[0]);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of());
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/resources/vlan/list HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        httpRequest = (GeneratedHttpRequest)((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        httpRequest = (GeneratedHttpRequest)((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/resources/vlan/list HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\nAuthorization: Basic aWRlbnRpdHk6Y3JlZGVudGlhbA==\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, SplitNewlinesAndReturnSecondField.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListVLANInfo() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(CloudSigmaAsyncClient.class, (String)"listVLANInfo", (Class[])new Class[0]);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of());
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/resources/vlan/info HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ListOfKeyValuesDelimitedByBlankLinesToVLANInfoSet.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testGetVLANInfo() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(CloudSigmaAsyncClient.class, (String)"getVLANInfo", (Class[])new Class[]{String.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"uuid"));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/resources/vlan/uuid/info HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, KeyValuesDelimitedByBlankLinesToVLANInfo.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testCreateVLAN() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(CloudSigmaAsyncClient.class, (String)"createVLAN", (Class[])new Class[]{String.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"poohbear"));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api.cloudsigma.com/resources/vlan/create HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, "name poohbear\n", "text/plain", false);
        this.assertResponseParserClassEquals(method, httpRequest, KeyValuesDelimitedByBlankLinesToVLANInfo.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testRenameVLAN() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(CloudSigmaAsyncClient.class, (String)"renameVLAN", (Class[])new Class[]{String.class, String.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"100", (Object)"poohbear"));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api.cloudsigma.com/resources/vlan/100/set HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, "name poohbear\n", "text/plain", false);
        this.assertResponseParserClassEquals(method, httpRequest, KeyValuesDelimitedByBlankLinesToVLANInfo.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testDestroyVLAN() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(CloudSigmaAsyncClient.class, (String)"destroyVLAN", (Class[])new Class[]{String.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"uuid"));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/resources/vlan/uuid/destroy HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.VoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListStaticIPs() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(CloudSigmaAsyncClient.class, (String)"listStaticIPs", (Class[])new Class[0]);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of());
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/resources/ip/list HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        httpRequest = (GeneratedHttpRequest)((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        httpRequest = (GeneratedHttpRequest)((HttpRequestFilter)Iterables.getOnlyElement((Iterable)httpRequest.getFilters())).filter((HttpRequest)httpRequest);
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/resources/ip/list HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\nAuthorization: Basic aWRlbnRpdHk6Y3JlZGVudGlhbA==\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, SplitNewlinesAndReturnSecondField.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testListStaticIPInfo() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(CloudSigmaAsyncClient.class, (String)"listStaticIPInfo", (Class[])new Class[0]);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of());
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/resources/ip/info HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ListOfKeyValuesDelimitedByBlankLinesToStaticIPInfoSet.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testGetStaticIPInfo() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(CloudSigmaAsyncClient.class, (String)"getStaticIPInfo", (Class[])new Class[]{String.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"uuid"));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/resources/ip/uuid/info HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, KeyValuesDelimitedByBlankLinesToStaticIPInfo.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testCreateStaticIP() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(CloudSigmaAsyncClient.class, (String)"createStaticIP", (Class[])new Class[0]);
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of());
        this.assertRequestLineEquals((HttpRequest)httpRequest, "POST https://api.cloudsigma.com/resources/ip/create HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, KeyValuesDelimitedByBlankLinesToStaticIPInfo.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    public void testDestroyStaticIP() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(CloudSigmaAsyncClient.class, (String)"destroyStaticIP", (Class[])new Class[]{String.class});
        GeneratedHttpRequest httpRequest = this.processor.createRequest(method, (List)ImmutableList.of((Object)"uuid"));
        this.assertRequestLineEquals((HttpRequest)httpRequest, "GET https://api.cloudsigma.com/resources/ip/uuid/destroy HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)httpRequest, "Accept: text/plain\n");
        this.assertPayloadEquals((HttpRequest)httpRequest, null, null, false);
        this.assertResponseParserClassEquals(method, httpRequest, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.VoidOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)httpRequest);
    }

    protected void checkFilters(HttpRequest request) {
        Assert.assertEquals((int)request.getFilters().size(), (int)1);
        Assert.assertEquals(((HttpRequestFilter)request.getFilters().get(0)).getClass(), BasicAuthentication.class);
    }

    protected ApiMetadata createApiMetadata() {
        return new CloudSigmaApiMetadata();
    }
}

