/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.binders;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.Invokable;
import com.google.inject.Guice;
import com.google.inject.Module;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.jclouds.cloudsigma.binders.BindCloneDriveOptionsToPlainTextString;
import org.jclouds.cloudsigma.options.CloneDriveOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.reflect.Invocation;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class BindCloneDriveOptionsToPlainTextStringTest {
    private static final BindCloneDriveOptionsToPlainTextString binder = (BindCloneDriveOptionsToPlainTextString)Guice.createInjector((Module[])new Module[0]).getInstance(BindCloneDriveOptionsToPlainTextString.class);

    public void testDefault() throws IOException {
        String expected = "name newdrive";
        GeneratedHttpRequest request = this.requestForArgs((List<Object>)ImmutableList.of());
        ImmutableMap map = ImmutableMap.of((Object)"name", (Object)"newdrive");
        Assert.assertEquals((Object)((GeneratedHttpRequest)binder.bindToRequest((HttpRequest)request, (Map)map)).getPayload().getRawContent(), (Object)expected);
    }

    public void testWithSize() throws IOException {
        String expected = "name newdrive\nsize 1024";
        GeneratedHttpRequest request = this.requestForArgs((List<Object>)ImmutableList.of((Object)new CloneDriveOptions().size(1024L)));
        ImmutableMap map = ImmutableMap.of((Object)"name", (Object)"newdrive");
        Assert.assertEquals((Object)((GeneratedHttpRequest)binder.bindToRequest((HttpRequest)request, (Map)map)).getPayload().getRawContent(), (Object)expected);
    }

    protected GeneratedHttpRequest requestForArgs(List<Object> args) {
        try {
            Invocation invocation = Invocation.create((Invokable)Reflection2.method(String.class, (String)"toString", (Class[])new Class[0]), args);
            return ((GeneratedHttpRequest.Builder)((GeneratedHttpRequest.Builder)GeneratedHttpRequest.builder().method("POST")).endpoint(URI.create("http://localhost/key"))).invocation(invocation).build();
        }
        catch (SecurityException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

