/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.compute;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Module;
import org.jclouds.compute.domain.ExecResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.internal.BaseComputeServiceLiveTest;
import org.jclouds.sshj.config.SshjSshClientModule;
import org.testng.annotations.Test;

@Test(groups={"live"}, testName="CloudSigmaComputeServiceLiveTest")
public class CloudSigmaComputeServiceLiveTest
extends BaseComputeServiceLiveTest {
    public CloudSigmaComputeServiceLiveTest() {
        this.provider = "cloudsigma";
    }

    protected Module getSshModule() {
        return new SshjSshClientModule();
    }

    protected void checkUserMetadataContains(NodeMetadata node, ImmutableMap<String, String> userMetadata) {
        assert (node.getUserMetadata().equals(ImmutableMap.of())) : String.format("node userMetadata did not match %s %s", userMetadata, node);
    }

    protected void checkTagsInNodeEquals(NodeMetadata node, ImmutableSet<String> tags) {
        assert (node.getTags().equals(ImmutableSet.of())) : String.format("node tags did not match %s %s", tags, node);
    }

    protected void checkResponseEqualsHostname(ExecResponse execResponse, NodeMetadata node1) {
        assert (execResponse.getOutput().trim().equals("ubuntu"));
    }

    public void testOptionToNotBlock() {
    }
}

