/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.functions;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.Map;
import org.jclouds.cloudsigma.domain.ClaimType;
import org.jclouds.cloudsigma.domain.Drive;
import org.jclouds.cloudsigma.functions.BaseDriveToMap;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class BaseDriveToMapTest {
    private static final BaseDriveToMap BASEDRIVE_TO_MAP = new BaseDriveToMap();

    public void testBasics() {
        Assert.assertEquals((Map)BASEDRIVE_TO_MAP.apply(new Drive.Builder().name("foo").size(100L).build()), (Map)ImmutableMap.of((Object)"name", (Object)"foo", (Object)"size", (Object)"100"));
    }

    public void testComplete() throws IOException {
        Drive one = new Drive.Builder().name("Ubuntu 10.10 Server Edition Linux 64bit Preinstalled System").size(0x200000000L).claimType(ClaimType.SHARED).tags((Iterable)ImmutableSet.of((Object)"foo", (Object)"bar", (Object)"baz")).readers((Iterable)ImmutableSet.of((Object)"ffffffff-ffff-ffff-ffff-ffffffffffff")).use((Iterable)ImmutableSet.of((Object)"tag1", (Object)"tag2")).build();
        Assert.assertEquals((Map)BASEDRIVE_TO_MAP.apply(one), (Map)ImmutableMap.builder().put((Object)"name", (Object)"Ubuntu 10.10 Server Edition Linux 64bit Preinstalled System").put((Object)"size", (Object)"8589934592").put((Object)"claim:type", (Object)"shared").put((Object)"tags", (Object)"foo bar baz").put((Object)"readers", (Object)"ffffffff-ffff-ffff-ffff-ffffffffffff").put((Object)"use", (Object)"tag1 tag2").build());
    }
}

