/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.functions;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Module;
import java.io.IOException;
import java.util.Map;
import org.jclouds.cloudsigma.domain.ClaimType;
import org.jclouds.cloudsigma.domain.DriveData;
import org.jclouds.cloudsigma.functions.DriveDataToMap;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class DriveDataToMapTest {
    private static final DriveDataToMap BASEDRIVE_TO_MAP = (DriveDataToMap)Guice.createInjector((Module[])new Module[0]).getInstance(DriveDataToMap.class);

    public void testRenameKeyWhenNotFound() {
        ImmutableMap nothing = ImmutableMap.of();
        Assert.assertEquals((Map)DriveDataToMap.renameKey((Map)nothing, (String)"foo", (String)"bar"), (Map)nothing);
    }

    public void testRenameKeyWhenFound() {
        ImmutableMap nothing = ImmutableMap.of((Object)"foo", (Object)"bar");
        Assert.assertEquals((Map)DriveDataToMap.renameKey((Map)nothing, (String)"foo", (String)"bar"), (Map)ImmutableMap.of((Object)"bar", (Object)"bar"));
    }

    public void testBasics() {
        Assert.assertEquals((Map)BASEDRIVE_TO_MAP.apply(new DriveData.Builder().name("foo").size(100L).build()), (Map)ImmutableMap.of((Object)"name", (Object)"foo", (Object)"size", (Object)"100"));
    }

    public void testComplete() throws IOException {
        DriveData one = new DriveData.Builder().name("Ubuntu 10.10 Server Edition Linux 64bit Preinstalled System").size(0x200000000L).claimType(ClaimType.SHARED).tags((Iterable)ImmutableSet.of((Object)"foo", (Object)"bar", (Object)"baz")).readers((Iterable)ImmutableSet.of((Object)"ffffffff-ffff-ffff-ffff-ffffffffffff")).use((Iterable)ImmutableSet.of((Object)"tag1", (Object)"tag2")).build();
        Assert.assertEquals((Map)BASEDRIVE_TO_MAP.apply(one), (Map)ImmutableMap.builder().put((Object)"name", (Object)"Ubuntu 10.10 Server Edition Linux 64bit Preinstalled System").put((Object)"size", (Object)"8589934592").put((Object)"claim:type", (Object)"shared").put((Object)"tags", (Object)"foo bar baz").put((Object)"readers", (Object)"ffffffff-ffff-ffff-ffff-ffffffffffff").put((Object)"use", (Object)"tag1 tag2").build());
    }
}

