/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudsigma.functions;

import com.google.common.base.Function;
import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.util.List;
import java.util.Map;
import org.jclouds.cloudsigma.domain.Device;
import org.jclouds.cloudsigma.domain.DriveMetrics;
import org.jclouds.cloudsigma.domain.NIC;
import org.jclouds.cloudsigma.domain.ServerMetrics;
import org.jclouds.cloudsigma.functions.KeyValuesDelimitedByBlankLinesToServerInfo;
import org.jclouds.cloudsigma.functions.MapToDevices;
import org.jclouds.cloudsigma.functions.MapToDriveMetrics;
import org.jclouds.cloudsigma.functions.MapToNICs;
import org.jclouds.cloudsigma.functions.MapToServerInfoTest;
import org.jclouds.cloudsigma.functions.MapToServerMetrics;
import org.jclouds.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class KeyValuesDelimitedByBlankLinesToServerInfoTest {
    private static final KeyValuesDelimitedByBlankLinesToServerInfo FN = (KeyValuesDelimitedByBlankLinesToServerInfo)Guice.createInjector((Module[])new Module[]{new AbstractModule(){

        protected void configure() {
            this.bind((TypeLiteral)new TypeLiteral<Function<Map<String, String>, List<NIC>>>(){}).to(MapToNICs.class);
            this.bind((TypeLiteral)new TypeLiteral<Function<Map<String, String>, Map<String, ? extends Device>>>(){}).to(MapToDevices.class);
            this.bind((TypeLiteral)new TypeLiteral<Function<Map<String, String>, Map<String, ? extends DriveMetrics>>>(){}).to(MapToDriveMetrics.class);
            this.bind((TypeLiteral)new TypeLiteral<Function<Map<String, String>, ServerMetrics>>(){}).to(MapToServerMetrics.class);
            this.bind((TypeLiteral)new TypeLiteral<Function<Device, String>>(){}).to(MapToDevices.DeviceToId.class);
        }
    }}).getInstance(KeyValuesDelimitedByBlankLinesToServerInfo.class);

    public void testNone() {
        Assert.assertEquals((Object)FN.apply(((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("").payload("")).build()), null);
        Assert.assertEquals((Object)FN.apply(((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("").payload("\n\n")).build()), null);
        Assert.assertEquals((Object)FN.apply(HttpResponse.builder().statusCode(200).message("").build()), null);
    }

    public void testOne() {
        Assert.assertEquals((Object)FN.apply(((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("").payload(MapToServerInfoTest.class.getResourceAsStream("/servers.txt"))).build()), (Object)MapToServerInfoTest.ONE);
    }

    public void testNew() {
        Assert.assertEquals((Object)FN.apply(((HttpResponse.Builder)HttpResponse.builder().statusCode(200).message("").payload(MapToServerInfoTest.class.getResourceAsStream("/new_server.txt"))).build()), (Object)MapToServerInfoTest.NEW);
    }
}

