/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Set;
import org.jclouds.cloudstack.CloudStackApiMetadata;
import org.jclouds.cloudstack.CloudStackClient;
import org.jclouds.cloudstack.CloudStackContext;
import org.jclouds.cloudstack.domain.AsyncCreateResponse;
import org.jclouds.cloudstack.domain.FirewallRule;
import org.jclouds.cloudstack.domain.PortForwardingRule;
import org.jclouds.cloudstack.features.FirewallClient;
import org.jclouds.cloudstack.internal.BaseCloudStackExpectTest;
import org.jclouds.cloudstack.options.CreateFirewallRuleOptions;
import org.jclouds.cloudstack.options.ListFirewallRulesOptions;
import org.jclouds.cloudstack.options.ListPortForwardingRulesOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.jclouds.rest.RestContext;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="FirewallClientExpectTest")
public class FirewallClientExpectTest
extends BaseCloudStackExpectTest<FirewallClient> {
    public void testListFirewallRulesWhenResponseIs2xx() {
        FirewallClient client = (FirewallClient)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=listFirewallRules&listAll=true&apiKey=identity&signature=9%2BtdTXe2uYLzAexPNgrMy5Tq8hE%3D")).addHeader("Accept", new String[]{"application/json"})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/listfirewallrulesresponse.json"))).build());
        ImmutableSet CIDRs = ImmutableSet.of((Object)"0.0.0.0/0");
        Assert.assertEquals((Set)client.listFirewallRules(new ListFirewallRulesOptions[0]), (Set)ImmutableSet.of((Object)FirewallRule.builder().id("2017").protocol(FirewallRule.Protocol.TCP).startPort(30).endPort(35).ipAddressId("2").ipAddress("10.27.27.51").state(FirewallRule.State.ACTIVE).CIDRs((Set)CIDRs).build(), (Object)FirewallRule.builder().id("2016").protocol(FirewallRule.Protocol.TCP).startPort(22).endPort(22).ipAddressId("2").ipAddress("10.27.27.51").state(FirewallRule.State.ACTIVE).CIDRs((Set)CIDRs).build(), (Object)FirewallRule.builder().id("10").protocol(FirewallRule.Protocol.TCP).startPort(22).endPort(22).ipAddressId("8").ipAddress("10.27.27.57").state(FirewallRule.State.ACTIVE).CIDRs((Set)CIDRs).build()));
    }

    public void testListFirewallRulesWhenReponseIs404() {
        FirewallClient client = (FirewallClient)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=listFirewallRules&listAll=true&apiKey=identity&signature=9%2BtdTXe2uYLzAexPNgrMy5Tq8hE%3D")).addHeader("Accept", new String[]{"application/json"})).build(), HttpResponse.builder().statusCode(404).build());
        Assert.assertEquals((Set)client.listFirewallRules(new ListFirewallRulesOptions[0]), (Set)ImmutableSet.of());
    }

    public void testGetFirewallRuleWhenResponseIs2xx() {
        FirewallClient client = (FirewallClient)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=listFirewallRules&listAll=true&id=2017&apiKey=identity&signature=6coh9Qdwla94TN1Dl008WlhzZUY%3D")).addHeader("Accept", new String[]{"application/json"})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/getfirewallrulesresponse.json"))).build());
        Assert.assertEquals((Object)client.getFirewallRule("2017"), (Object)FirewallRule.builder().id("2017").protocol(FirewallRule.Protocol.TCP).startPort(30).endPort(35).ipAddressId("2").ipAddress("10.27.27.51").state(FirewallRule.State.ACTIVE).CIDRs((Set)ImmutableSet.of((Object)"0.0.0.0/0")).build());
    }

    public void testGetFirewallRuleWhenResponseIs404() {
        FirewallClient client = (FirewallClient)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=listFirewallRules&listAll=true&id=4&apiKey=identity&signature=rYd8gr7ptdSZlIehBEMQEKsm07Q%3D")).addHeader("Accept", new String[]{"application/json"})).build(), HttpResponse.builder().statusCode(404).build());
        Assert.assertNull((Object)client.getFirewallRule("4"));
    }

    public void testCreateFirewallRuleForIpAndProtocol() {
        FirewallClient client = (FirewallClient)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=createFirewallRule&ipaddressid=2&protocol=TCP&apiKey=identity&signature=d0MZ/yhQPAaV%2BYQmfZsQtQL2C28%3D")).addHeader("Accept", new String[]{"application/json"})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/createfirewallrulesresponse.json"))).build());
        AsyncCreateResponse response = client.createFirewallRuleForIpAndProtocol("2", FirewallRule.Protocol.TCP, new CreateFirewallRuleOptions[0]);
        Assert.assertEquals((String)response.getJobId(), (String)"2036");
        Assert.assertEquals((String)response.getId(), (String)"2017");
    }

    public void testDeleteFirewallRule() {
        FirewallClient client = (FirewallClient)this.requestSendsResponse(HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=deleteFirewallRule&id=2015&apiKey=identity&signature=/T5FAO2yGPctaPmg7TEtIEFW3EU%3D")).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/deletefirewallrulesresponse.json"))).build());
        client.deleteFirewallRule("2015");
    }

    public void testListPortForwardingRulesWhenResponseIs2xx() {
        FirewallClient client = (FirewallClient)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=listPortForwardingRules&listAll=true&apiKey=identity&signature=8SXGJZWdcJfVz4V90Pyod12x9dM%3D")).addHeader("Accept", new String[]{"application/json"})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/listportforwardingrulesresponse.json"))).build());
        ImmutableSet cidrs = ImmutableSet.of((Object)"0.0.0.0/1", (Object)"128.0.0.0/1");
        Assert.assertEquals((Set)client.listPortForwardingRules(new ListPortForwardingRulesOptions[0]), (Set)ImmutableSet.of((Object)PortForwardingRule.builder().id("15").privatePort(22).protocol(PortForwardingRule.Protocol.TCP).publicPort(2022).virtualMachineId("3").virtualMachineName("i-3-3-VM").IPAddressId("3").IPAddress("72.52.126.32").state(PortForwardingRule.State.ACTIVE).CIDRs((Set)cidrs).build(), (Object)PortForwardingRule.builder().id("18").privatePort(22).protocol(PortForwardingRule.Protocol.TCP).publicPort(22).virtualMachineId("89").virtualMachineName("i-3-89-VM").IPAddressId("34").IPAddress("72.52.126.63").state(PortForwardingRule.State.ACTIVE).build()));
    }

    public void testListPortForwardingRulesWhenReponseIs404() {
        FirewallClient client = (FirewallClient)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=listPortForwardingRules&listAll=true&apiKey=identity&signature=8SXGJZWdcJfVz4V90Pyod12x9dM%3D")).addHeader("Accept", new String[]{"application/json"})).build(), HttpResponse.builder().statusCode(404).build());
        Assert.assertEquals((Set)client.listPortForwardingRules(new ListPortForwardingRulesOptions[0]), (Set)ImmutableSet.of());
    }

    public void testGetPortForwardingRuleWhenResponseIs2xx() {
        FirewallClient client = (FirewallClient)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=listPortForwardingRules&listAll=true&id=15&apiKey=identity&signature=JL63p6cJzbb9vaffeV4u60IGlWE%3D")).addHeader("Accept", new String[]{"application/json"})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/getportforwardingrulesresponse.json"))).build());
        ImmutableSet cidrs = ImmutableSet.of((Object)"0.0.0.0/1", (Object)"128.0.0.0/1");
        Assert.assertEquals((Object)client.getPortForwardingRule("15"), (Object)PortForwardingRule.builder().id("15").privatePort(22).protocol(PortForwardingRule.Protocol.TCP).publicPort(2022).virtualMachineId("3").virtualMachineName("i-3-3-VM").IPAddressId("3").IPAddress("72.52.126.32").state(PortForwardingRule.State.ACTIVE).CIDRs((Set)cidrs).build());
    }

    public void testGetPortForwardingRuleWhenResponseIs404() {
        FirewallClient client = (FirewallClient)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=listPortForwardingRules&listAll=true&id=4&apiKey=identity&signature=4blbBVn2%2BZfF8HwoglbmtYoDAjs%3D")).addHeader("Accept", new String[]{"application/json"})).build(), HttpResponse.builder().statusCode(404).build());
        Assert.assertNull((Object)client.getPortForwardingRule("4"));
    }

    public void testCreatePortForwardingRuleForVirtualMachine() {
        FirewallClient client = (FirewallClient)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint("http://localhost:8080/client/api").addQueryParam("response", new String[]{"json"}).addQueryParam("command", new String[]{"createPortForwardingRule"}).addQueryParam("ipaddressid", new String[]{"2"}).addQueryParam("protocol", new String[]{"tcp"}).addQueryParam("publicport", new String[]{"22"}).addQueryParam("virtualmachineid", new String[]{"1234"}).addQueryParam("privateport", new String[]{"22"}).addQueryParam("apiKey", new String[]{"identity"}).addQueryParam("signature", new String[]{"84dtGzQp0G6k3z3Gkc3F/HBNS2Y%3D"}).addHeader("Accept", new String[]{"application/json"})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/createportforwardingrulesresponse.json"))).build());
        AsyncCreateResponse response = client.createPortForwardingRuleForVirtualMachine("2", PortForwardingRule.Protocol.TCP, 22, "1234", 22);
        Assert.assertEquals((String)response.getJobId(), (String)"2035");
        Assert.assertEquals((String)response.getId(), (String)"2015");
    }

    public void testDeletePortForwardingRule() {
        FirewallClient client = (FirewallClient)this.requestSendsResponse(HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=deletePortForwardingRule&id=2015&apiKey=identity&signature=2UE7KB3wm5ocmR%2BGMNFKPKfiDo8%3D")).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/deleteportforwardingrulesresponse.json"))).build());
        client.deletePortForwardingRule("2015");
    }

    public void testListEgressFirewallRulesWhenResponseIs2xx() {
        FirewallClient client = (FirewallClient)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=listEgressFirewallRules&listAll=true&apiKey=identity&signature=j3OpRXs7mEwVKs9KIb4ncRKVO9A%3D")).addHeader("Accept", new String[]{"application/json"})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/listegressfirewallrulesresponse.json"))).build());
        ImmutableSet CIDRs = ImmutableSet.of((Object)"0.0.0.0/0");
        Assert.assertEquals((Set)client.listEgressFirewallRules(new ListFirewallRulesOptions[0]), (Set)ImmutableSet.of((Object)FirewallRule.builder().id("2017").protocol(FirewallRule.Protocol.TCP).startPort(30).endPort(35).ipAddressId("2").ipAddress("10.27.27.51").state(FirewallRule.State.ACTIVE).CIDRs((Set)CIDRs).build(), (Object)FirewallRule.builder().id("2016").protocol(FirewallRule.Protocol.TCP).startPort(22).endPort(22).ipAddressId("2").ipAddress("10.27.27.51").state(FirewallRule.State.ACTIVE).CIDRs((Set)CIDRs).build(), (Object)FirewallRule.builder().id("10").protocol(FirewallRule.Protocol.TCP).startPort(22).endPort(22).ipAddressId("8").ipAddress("10.27.27.57").state(FirewallRule.State.ACTIVE).CIDRs((Set)CIDRs).build()));
    }

    public void testListEgressFirewallRulesWhenReponseIs404() {
        FirewallClient client = (FirewallClient)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=listEgressFirewallRules&listAll=true&apiKey=identity&signature=j3OpRXs7mEwVKs9KIb4ncRKVO9A%3D")).addHeader("Accept", new String[]{"application/json"})).build(), HttpResponse.builder().statusCode(404).build());
        Assert.assertEquals((Set)client.listEgressFirewallRules(new ListFirewallRulesOptions[0]), (Set)ImmutableSet.of());
    }

    public void testGetEgressFirewallRuleWhenResponseIs2xx() {
        FirewallClient client = (FirewallClient)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=listEgressFirewallRules&listAll=true&id=2017&apiKey=identity&signature=Hi1K5VA3yd3mk0AmgJ2F6y%2BVzMo%3D")).addHeader("Accept", new String[]{"application/json"})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/getegressfirewallrulesresponse.json"))).build());
        Assert.assertEquals((Object)client.getEgressFirewallRule("2017"), (Object)FirewallRule.builder().id("2017").protocol(FirewallRule.Protocol.TCP).startPort(30).endPort(35).ipAddressId("2").ipAddress("10.27.27.51").state(FirewallRule.State.ACTIVE).CIDRs((Set)ImmutableSet.of((Object)"0.0.0.0/0")).build());
    }

    public void testGetEgressFirewallRuleWhenResponseIs404() {
        FirewallClient client = (FirewallClient)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=listEgressFirewallRules&listAll=true&id=4&apiKey=identity&signature=dzb5azKxXZsuGrNRJbRHfna7FMo%3D")).addHeader("Accept", new String[]{"application/json"})).build(), HttpResponse.builder().statusCode(404).build());
        Assert.assertNull((Object)client.getEgressFirewallRule("4"));
    }

    public void testCreateEgressFirewallRuleForIpAndProtocol() {
        FirewallClient client = (FirewallClient)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=createEgressFirewallRule&ipaddressid=2&protocol=TCP&apiKey=identity&signature=%2BlfEJ5zB7lxqRAn0rY0Rcfg9buw%3D")).addHeader("Accept", new String[]{"application/json"})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/createegressfirewallrulesresponse.json"))).build());
        AsyncCreateResponse response = client.createEgressFirewallRuleForIpAndProtocol("2", FirewallRule.Protocol.TCP, new CreateFirewallRuleOptions[0]);
        Assert.assertEquals((String)response.getJobId(), (String)"2036");
        Assert.assertEquals((String)response.getId(), (String)"2017");
    }

    public void testDeleteEgressFirewallRule() {
        FirewallClient client = (FirewallClient)this.requestSendsResponse(HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=deleteEgressFirewallRule&id=2015&apiKey=identity&signature=S119WNmamKwc5d9qvvkIJznXytg%3D")).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/deleteegressfirewallrulesresponse.json"))).build());
        client.deleteEgressFirewallRule("2015");
    }

    @Override
    protected FirewallClient clientFrom(CloudStackContext context) {
        return ((CloudStackClient)((RestContext)context.unwrap(CloudStackApiMetadata.CONTEXT_TOKEN)).getApi()).getFirewallClient();
    }
}

