/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.features;

import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.Set;
import org.jclouds.cloudstack.CloudStackContext;
import org.jclouds.cloudstack.CloudStackGlobalClient;
import org.jclouds.cloudstack.domain.VlanIPRange;
import org.jclouds.cloudstack.features.GlobalVlanClient;
import org.jclouds.cloudstack.internal.BaseCloudStackExpectTest;
import org.jclouds.cloudstack.options.CreateVlanIPRangeOptions;
import org.jclouds.cloudstack.options.ListVlanIPRangesOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="GlobalVlanClientExpectTest")
public class GlobalVlanClientExpectTest
extends BaseCloudStackExpectTest<GlobalVlanClient> {
    public void testListVlanIpRangesWhenResponseIs2xx() {
        GlobalVlanClient client = (GlobalVlanClient)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=listVlanIpRanges&listAll=true&apiKey=identity&signature=xPwCeAcMp9kDGbD5oPgztLtSdnU%3D")).addHeader("Accept", new String[]{"application/json"})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/listvlaniprangesresponse.json"))).build());
        VlanIPRange range1 = VlanIPRange.builder().id("1").forVirtualNetwork(true).zoneId("1").vlan("127").account("system").domainId("1").domain("ROOT").gateway("10.27.27.254").netmask("255.255.255.0").startIP("10.27.27.50").endIP("10.27.27.100").networkId("200").build();
        VlanIPRange range2 = VlanIPRange.builder().id("2").forVirtualNetwork(false).zoneId("2").vlan("untagged").account("system").domainId("1").domain("ROOT").podId("2").podName("Dev Pod 2").gateway("10.22.22.254").netmask("255.255.255.0").startIP("10.22.22.51").endIP("10.22.22.100").networkId("209").build();
        Assert.assertEquals((Set)client.listVlanIPRanges(new ListVlanIPRangesOptions[0]), (Set)ImmutableSet.of((Object)range1, (Object)range2));
    }

    public void testListVlanIpRangesWhenResponseIs404() {
        GlobalVlanClient client = (GlobalVlanClient)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=listVlanIpRanges&listAll=true&apiKey=identity&signature=xPwCeAcMp9kDGbD5oPgztLtSdnU%3D")).addHeader("Accept", new String[]{"application/json"})).build(), HttpResponse.builder().statusCode(404).build());
        Assert.assertEquals((Set)client.listVlanIPRanges(new ListVlanIPRangesOptions[0]), (Set)ImmutableSet.of());
    }

    public void testCreateVlanIpRangeWhenResponseIs2xx() {
        GlobalVlanClient client = (GlobalVlanClient)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=createVlanIpRange&startip=10.22.22.51&endip=10.22.22.100&forvirtualnetwork=false&zoneid=2&vlan=untagged&account=system&domainid=1&podid=2&gateway=10.22.22.254&netmask=255.255.255.0&networkid=209&apiKey=identity&signature=XgDjPYAQNLMVCuSMGRA6QjV8mOY%3D")).addHeader("Accept", new String[]{"application/json"})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/createvlaniprangeresponse.json"))).build());
        VlanIPRange actual = client.createVlanIPRange("10.22.22.51", "10.22.22.100", new CreateVlanIPRangeOptions[]{new CreateVlanIPRangeOptions().forVirtualNetwork(false).zoneId("2").vlan("untagged").accountInDomain("system", "1").podId("2").gateway("10.22.22.254").netmask("255.255.255.0").networkId("209")});
        VlanIPRange expected = VlanIPRange.builder().id("2").forVirtualNetwork(false).zoneId("2").vlan("untagged").account("system").domainId("1").domain("ROOT").podId("2").podName("Dev Pod 2").gateway("10.22.22.254").netmask("255.255.255.0").startIP("10.22.22.51").endIP("10.22.22.100").networkId("209").build();
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    public void testDeleteVlanIpRangeWhenResponseIs2xx() {
        GlobalVlanClient client = (GlobalVlanClient)this.requestSendsResponse(((HttpRequest.Builder)HttpRequest.builder().method("GET").endpoint(URI.create("http://localhost:8080/client/api?response=json&command=deleteVlanIpRange&id=1&apiKey=identity&signature=tTBbpdCndgHXdR397fbbJaN1RZU%3D")).addHeader("Accept", new String[]{"application/json"})).build(), ((HttpResponse.Builder)HttpResponse.builder().statusCode(200).payload(this.payloadFromResource("/createvlaniprangeresponse.json"))).build());
        client.deleteVlanIPRange("1");
    }

    @Override
    protected GlobalVlanClient clientFrom(CloudStackContext context) {
        return ((CloudStackGlobalClient)context.getGlobalContext().getApi()).getVlanClient();
    }
}

