/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.loaders;

import org.easymock.EasyMock;
import org.jclouds.cloudstack.domain.LoginResponse;
import org.jclouds.cloudstack.features.SessionClient;
import org.jclouds.cloudstack.loaders.LoginWithPasswordCredentials;
import org.jclouds.domain.Credentials;
import org.testng.annotations.Test;

public class LoginWithPasswordCredentialsTest {
    @Test
    public void testWithDoubleDomainname() {
        LoginResponse response = (LoginResponse)EasyMock.createMock(LoginResponse.class);
        SessionClient client = (SessionClient)EasyMock.createMock(SessionClient.class);
        EasyMock.expect((Object)client.loginUserInDomainWithHashOfPassword((String)EasyMock.eq((Object)"User"), (String)EasyMock.eq((Object)"Test/Domain"), (String)EasyMock.anyObject())).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{client});
        LoginWithPasswordCredentials obj = new LoginWithPasswordCredentials(client);
        Credentials cred = new Credentials("Test/Domain/User", "koffiedik");
        obj.load(cred);
    }

    @Test
    public void testWithSingleDomainname() {
        LoginResponse response = (LoginResponse)EasyMock.createMock(LoginResponse.class);
        SessionClient client = (SessionClient)EasyMock.createMock(SessionClient.class);
        EasyMock.expect((Object)client.loginUserInDomainWithHashOfPassword((String)EasyMock.eq((Object)"User"), (String)EasyMock.eq((Object)"Domain"), (String)EasyMock.anyObject())).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{client});
        LoginWithPasswordCredentials obj = new LoginWithPasswordCredentials(client);
        Credentials cred = new Credentials("Domain/User", "koffiedik");
        obj.load(cred);
    }

    @Test
    public void testWithNoDomainname() {
        LoginResponse response = (LoginResponse)EasyMock.createMock(LoginResponse.class);
        SessionClient client = (SessionClient)EasyMock.createMock(SessionClient.class);
        EasyMock.expect((Object)client.loginUserInDomainWithHashOfPassword((String)EasyMock.eq((Object)"User"), (String)EasyMock.eq((Object)""), (String)EasyMock.anyObject())).andReturn((Object)response);
        EasyMock.replay((Object[])new Object[]{client});
        LoginWithPasswordCredentials obj = new LoginWithPasswordCredentials(client);
        Credentials cred = new Credentials("User", "koffiedik");
        obj.load(cred);
    }
}

