/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.predicates;

import org.easymock.EasyMock;
import org.jclouds.cloudstack.CloudStackClient;
import org.jclouds.cloudstack.domain.VirtualMachine;
import org.jclouds.cloudstack.features.VirtualMachineClient;
import org.jclouds.cloudstack.predicates.VirtualMachineExpunged;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"unit"}, singleThreaded=true, testName="VirtualMachineExpungedTest")
public class VirtualMachineExpungedTest {
    CloudStackClient client;
    VirtualMachineClient virtualMachineClient;

    @BeforeMethod
    public void setUp() {
        this.client = (CloudStackClient)EasyMock.createMock(CloudStackClient.class);
        this.virtualMachineClient = (VirtualMachineClient)EasyMock.createMock(VirtualMachineClient.class);
        EasyMock.expect((Object)this.client.getVirtualMachineClient()).andReturn((Object)this.virtualMachineClient);
    }

    @Test
    public void testWaitForVirtualMachineToBeExpunged() {
        VirtualMachine virtualMachine = VirtualMachine.builder().id("229").build();
        EasyMock.expect((Object)this.virtualMachineClient.getVirtualMachine(virtualMachine.getId())).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.client, this.virtualMachineClient});
        Assert.assertTrue((boolean)new VirtualMachineExpunged(this.client).apply(virtualMachine));
        EasyMock.verify((Object[])new Object[]{this.client, this.virtualMachineClient});
    }

    @Test
    public void testNoRemovedYet() {
        VirtualMachine virtualMachine = VirtualMachine.builder().id("229").build();
        EasyMock.expect((Object)this.virtualMachineClient.getVirtualMachine(virtualMachine.getId())).andReturn((Object)virtualMachine);
        EasyMock.replay((Object[])new Object[]{this.client, this.virtualMachineClient});
        Assert.assertFalse((boolean)new VirtualMachineExpunged(this.client).apply(virtualMachine));
        EasyMock.verify((Object[])new Object[]{this.client, this.virtualMachineClient});
    }
}

