/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudstack.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import org.jclouds.cloudstack.domain.IngressRule;
import org.jclouds.cloudstack.domain.SecurityGroup;

public class SecurityGroupPredicates {
    public static Predicate<SecurityGroup> portInRange(final int port) {
        return new Predicate<SecurityGroup>(){

            public boolean apply(SecurityGroup group) {
                return Iterables.any(group.getIngressRules(), (Predicate)new Predicate<IngressRule>(){

                    public boolean apply(IngressRule rule) {
                        return rule.getStartPort() <= port && rule.getEndPort() >= port;
                    }
                });
            }

            public String toString() {
                return "portInRange(" + port + ")";
            }
        };
    }

    public static Predicate<SecurityGroup> hasCidr(final String cidr) {
        return new Predicate<SecurityGroup>(){

            public boolean apply(SecurityGroup group) {
                return Iterables.any(group.getIngressRules(), (Predicate)new Predicate<IngressRule>(){

                    public boolean apply(IngressRule rule) {
                        return rule.getCIDR() != null && rule.getCIDR().equals(cidr);
                    }
                });
            }

            public String toString() {
                return "hasCidr(" + cidr + ")";
            }
        };
    }

    public static Predicate<SecurityGroup> portInRangeForCidr(final int port, final String cidr) {
        return new Predicate<SecurityGroup>(){

            public boolean apply(SecurityGroup group) {
                return Iterables.any(group.getIngressRules(), (Predicate)new Predicate<IngressRule>(){

                    public boolean apply(IngressRule rule) {
                        return rule.getCIDR() != null && rule.getCIDR().equals(cidr) && rule.getStartPort() <= port && rule.getEndPort() >= port;
                    }
                });
            }

            public String toString() {
                return "portInRangeForCidr(" + port + ", " + cidr + ")";
            }
        };
    }

    public static Predicate<SecurityGroup> any() {
        return Predicates.alwaysTrue();
    }

    public static Predicate<SecurityGroup> nameEquals(final String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name must be defined");
        return new Predicate<SecurityGroup>(){

            public boolean apply(SecurityGroup ext) {
                return name.equals(ext.getName());
            }

            public String toString() {
                return "nameEquals(" + name + ")";
            }
        };
    }

    public static Predicate<SecurityGroup> nameMatches(final Predicate<String> name) {
        Preconditions.checkNotNull(name, (Object)"name must be defined");
        return new Predicate<SecurityGroup>(){

            public boolean apply(SecurityGroup ext) {
                return name.apply((Object)ext.getName());
            }

            public String toString() {
                return "nameMatches(" + name + ")";
            }
        };
    }
}

