/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.binders;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Date;
import org.jclouds.cloudwatch.binders.MetricDataBinder;
import org.jclouds.cloudwatch.domain.Dimension;
import org.jclouds.cloudwatch.domain.MetricDatum;
import org.jclouds.cloudwatch.domain.StatisticValues;
import org.jclouds.cloudwatch.domain.Unit;
import org.jclouds.http.HttpRequest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="MetricDataBinderTest")
public class MetricDataBinderTest {
    Injector injector = Guice.createInjector((Module[])new Module[0]);
    MetricDataBinder binder = (MetricDataBinder)this.injector.getInstance(MetricDataBinder.class);

    HttpRequest request() {
        return HttpRequest.builder().method("POST").endpoint("http://localhost").build();
    }

    public void testMetricWithoutTimestamp() throws Exception {
        StatisticValues ss = StatisticValues.builder().maximum(4.0).minimum(1.0).sampleCount(4.0).sum(10.0).build();
        MetricDatum metricDatum = MetricDatum.builder().metricName("TestMetricName").statisticValues(ss).dimension(new Dimension("TestDimension", "FAKE")).unit(Unit.COUNT).build();
        HttpRequest request = this.binder.bindToRequest(this.request(), (Object)ImmutableSet.of((Object)metricDatum));
        Assert.assertEquals((Object)request.getPayload().getRawContent(), (Object)("MetricData.member.1.Dimensions.member.1.Name=TestDimension&MetricData.member.1.Dimensions.member.1.Value=FAKE&MetricData.member.1.MetricName=TestMetricName&MetricData.member.1.StatisticValues.Maximum=4.0&MetricData.member.1.StatisticValues.Minimum=1.0&MetricData.member.1.StatisticValues.SampleCount=4.0&MetricData.member.1.StatisticValues.Sum=10.0&MetricData.member.1.Unit=" + Unit.COUNT.toString()));
    }

    public void testMetricWithMultipleDimensions() throws Exception {
        MetricDatum metricDatum = MetricDatum.builder().metricName("TestMetricName").dimension(new Dimension("TestDimension", "FAKE")).dimension(new Dimension("TestDimension2", "FAKE2")).unit(Unit.COUNT).timestamp(new Date(10000000L)).value(Double.valueOf(5.0)).build();
        HttpRequest request = this.binder.bindToRequest(this.request(), (Object)ImmutableSet.of((Object)metricDatum));
        Assert.assertEquals((Object)request.getPayload().getRawContent(), (Object)("MetricData.member.1.Dimensions.member.1.Name=TestDimension&MetricData.member.1.Dimensions.member.1.Value=FAKE&MetricData.member.1.Dimensions.member.2.Name=TestDimension2&MetricData.member.1.Dimensions.member.2.Value=FAKE2&MetricData.member.1.MetricName=TestMetricName&MetricData.member.1.Timestamp=1970-01-01T02%3A46%3A40Z&MetricData.member.1.Unit=" + Unit.COUNT.toString() + "&MetricData.member.1.Value=5.0"));
    }

    public void testMetricWithMultipleDatum() throws Exception {
        StatisticValues ss = StatisticValues.builder().maximum(4.0).minimum(1.0).sampleCount(4.0).sum(10.0).build();
        MetricDatum metricDatum = MetricDatum.builder().metricName("TestMetricName").statisticValues(ss).dimension(new Dimension("TestDimension", "FAKE")).dimension(new Dimension("TestDimension2", "FAKE2")).unit(Unit.COUNT).timestamp(new Date(10000000L)).value(Double.valueOf(2.0)).build();
        MetricDatum metricDatum2 = MetricDatum.builder().metricName("TestMetricName").dimension(new Dimension("TestDimension", "FAKE")).unit(Unit.COUNT).timestamp(new Date(10000000L)).value(Double.valueOf(5.0)).build();
        HttpRequest request = this.binder.bindToRequest(this.request(), (Object)ImmutableSet.of((Object)metricDatum, (Object)metricDatum2));
        Assert.assertEquals((Object)request.getPayload().getRawContent(), (Object)("MetricData.member.1.Dimensions.member.1.Name=TestDimension&MetricData.member.1.Dimensions.member.1.Value=FAKE&MetricData.member.1.Dimensions.member.2.Name=TestDimension2&MetricData.member.1.Dimensions.member.2.Value=FAKE2&MetricData.member.1.MetricName=TestMetricName&MetricData.member.1.StatisticValues.Maximum=4.0&MetricData.member.1.StatisticValues.Minimum=1.0&MetricData.member.1.StatisticValues.SampleCount=4.0&MetricData.member.1.StatisticValues.Sum=10.0&MetricData.member.1.Timestamp=1970-01-01T02%3A46%3A40Z&MetricData.member.1.Unit=" + Unit.COUNT.toString() + "&MetricData.member.1.Value=2.0" + "&MetricData.member.2.Dimensions.member.1.Name=TestDimension" + "&MetricData.member.2.Dimensions.member.1.Value=FAKE" + "&MetricData.member.2.MetricName=TestMetricName" + "&MetricData.member.2.Timestamp=1970-01-01T02%3A46%3A40Z" + "&MetricData.member.2.Unit=" + Unit.COUNT.toString() + "&MetricData.member.2.Value=5.0"));
    }
}

