/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.options;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Set;
import org.jclouds.cloudwatch.domain.Alarm;
import org.jclouds.cloudwatch.options.ListAlarmsOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ListAlarmsOptionsTest {
    public void testEmptyOptions() throws Exception {
        Multimap formParameters = new ListAlarmsOptions().buildFormParameters();
        Assert.assertFalse((boolean)formParameters.containsKey((Object)"ActionPrefix"));
        Assert.assertFalse((boolean)formParameters.containsKey((Object)"AlarmNamePrefix"));
        Assert.assertFalse((boolean)formParameters.containsKey((Object)"AlarmNames.member.1"));
        Assert.assertFalse((boolean)formParameters.containsKey((Object)"MaxRecords"));
        Assert.assertFalse((boolean)formParameters.containsKey((Object)"NextToken"));
        Assert.assertFalse((boolean)formParameters.containsKey((Object)"StateValue"));
    }

    public void testPopulatedOptions() throws Exception {
        String actionPrefix = "TestActionPrefix";
        String alarmNamePrefix = "TestAlarmNamePrefix";
        ImmutableSet alarmNames = ImmutableSet.of((Object)"TestAlarmName1", (Object)"TestAlarmName2");
        int maxRecords = 5;
        Alarm.State state = Alarm.State.ALARM;
        int alarmNameIndex = 1;
        Multimap formParameters = new ListAlarmsOptions().actionPrefix(actionPrefix).alarmNamePrefix(alarmNamePrefix).alarmNames((Set)alarmNames).maxRecords(maxRecords).state(state).buildFormParameters();
        Assert.assertEquals((Collection)formParameters.get((Object)"ActionPrefix"), (Collection)ImmutableSet.of((Object)actionPrefix));
        Assert.assertEquals((Collection)formParameters.get((Object)"AlarmNamePrefix"), (Collection)ImmutableSet.of((Object)alarmNamePrefix));
        Assert.assertEquals((Collection)formParameters.get((Object)"MaxRecords"), (Collection)ImmutableSet.of((Object)Integer.toString(maxRecords)));
        Assert.assertEquals((Collection)formParameters.get((Object)"StateValue"), (Collection)ImmutableSet.of((Object)state.toString()));
        for (String alarmName : alarmNames) {
            Assert.assertEquals((Collection)formParameters.get((Object)("AlarmNames.member." + alarmNameIndex)), (Collection)ImmutableSet.of((Object)alarmName));
            ++alarmNameIndex;
        }
    }
}

