/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.options;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Set;
import org.jclouds.cloudwatch.domain.ComparisonOperator;
import org.jclouds.cloudwatch.domain.Dimension;
import org.jclouds.cloudwatch.domain.Statistics;
import org.jclouds.cloudwatch.domain.Unit;
import org.jclouds.cloudwatch.options.SaveAlarmOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class SaveAlarmOptionsTest {
    public void testEmptyOptions() throws Exception {
        Multimap formParameters = new SaveAlarmOptions().buildFormParameters();
        Assert.assertFalse((boolean)formParameters.containsKey((Object)"ActionsEnabled"));
        Assert.assertFalse((boolean)formParameters.containsKey((Object)"AlarmActions.member.1"));
        Assert.assertFalse((boolean)formParameters.containsKey((Object)"AlarmDescription"));
        Assert.assertFalse((boolean)formParameters.containsKey((Object)"AlarmName"));
        Assert.assertFalse((boolean)formParameters.containsKey((Object)"ComparisonOperator"));
        Assert.assertFalse((boolean)formParameters.containsKey((Object)"Dimensions.member.1.Name"));
        Assert.assertFalse((boolean)formParameters.containsKey((Object)"Dimensions.member.1.Value"));
        Assert.assertFalse((boolean)formParameters.containsKey((Object)"EvaluationPeriods"));
        Assert.assertFalse((boolean)formParameters.containsKey((Object)"InsufficientDataActions.member.1"));
        Assert.assertFalse((boolean)formParameters.containsKey((Object)"MetricName"));
        Assert.assertFalse((boolean)formParameters.containsKey((Object)"Namespace"));
        Assert.assertFalse((boolean)formParameters.containsKey((Object)"OKActions.member.1"));
        Assert.assertFalse((boolean)formParameters.containsKey((Object)"Period"));
        Assert.assertFalse((boolean)formParameters.containsKey((Object)"Statistic"));
        Assert.assertFalse((boolean)formParameters.containsKey((Object)"Threshold"));
        Assert.assertFalse((boolean)formParameters.containsKey((Object)"Unit"));
    }

    public void testPopulatedOptions() throws Exception {
        boolean actionsEnabled = false;
        ImmutableSet alarmActions = ImmutableSet.of((Object)"TestAlarmAction1", (Object)"TestAlarmAction2");
        String alarmDescription = "TestAlarmDescription";
        String alarmName = "TestAlarmName";
        ComparisonOperator comparisonOperator = ComparisonOperator.GREATER_THAN_OR_EQUAL_TO_THRESHOLD;
        ImmutableSet dimensions = ImmutableSet.of((Object)new Dimension("TestDimension1", "TestValue1"), (Object)new Dimension("TestDimension2", "TestValue2"));
        int evaluationPeriods = 360;
        ImmutableSet insufficientDataActions = ImmutableSet.of((Object)"TestInsufficientDataAction1", (Object)"TestInsufficientDataAction2");
        String metricName = "TestMetricName";
        String namespace = "AWS/AutoScaling";
        ImmutableSet okActions = ImmutableSet.of((Object)"TestOKAction1", (Object)"TestOKAction2");
        int period = 300;
        Statistics statistic = Statistics.SAMPLE_COUNT;
        double threshold = 1.0;
        Unit unit = Unit.BITS;
        Multimap formParameters = new SaveAlarmOptions().actionsEnabled(actionsEnabled).alarmActions((Set)alarmActions).alarmDescription(alarmDescription).alarmName(alarmName).comparisonOperator(comparisonOperator).dimensions((Set)dimensions).evaluationPeriods(evaluationPeriods).insufficientDataActions((Set)insufficientDataActions).metricName(metricName).namespace(namespace).okActions((Set)okActions).period(period).statistic(statistic).threshold(threshold).unit(unit).buildFormParameters();
        int alarmActionIndex = 1;
        int dimensionIndex = 1;
        int insufficientDataActionIndex = 1;
        int okActionIndex = 1;
        for (String alarmAction : alarmActions) {
            Assert.assertEquals((Collection)formParameters.get((Object)("AlarmActions.member." + alarmActionIndex)), (Collection)ImmutableSet.of((Object)alarmAction));
            ++alarmActionIndex;
        }
        for (Dimension dimension : dimensions) {
            Assert.assertEquals((Collection)formParameters.get((Object)("Dimensions.member." + dimensionIndex + ".Name")), (Collection)ImmutableSet.of((Object)dimension.getName()));
            Assert.assertEquals((Collection)formParameters.get((Object)("Dimensions.member." + dimensionIndex + ".Value")), (Collection)ImmutableSet.of((Object)dimension.getValue()));
            ++dimensionIndex;
        }
        for (String insufficientDataAction : insufficientDataActions) {
            Assert.assertEquals((Collection)formParameters.get((Object)("InsufficientDataActions.member." + insufficientDataActionIndex)), (Collection)ImmutableSet.of((Object)insufficientDataAction));
            ++insufficientDataActionIndex;
        }
        for (String okAction : okActions) {
            Assert.assertEquals((Collection)formParameters.get((Object)("OKActions.member." + okActionIndex)), (Collection)ImmutableSet.of((Object)okAction));
            ++okActionIndex;
        }
        Assert.assertEquals((Collection)formParameters.get((Object)"ActionsEnabled"), (Collection)ImmutableSet.of((Object)Boolean.toString(actionsEnabled)));
        Assert.assertEquals((Collection)formParameters.get((Object)"AlarmDescription"), (Collection)ImmutableSet.of((Object)alarmDescription));
        Assert.assertEquals((Collection)formParameters.get((Object)"AlarmName"), (Collection)ImmutableSet.of((Object)alarmName));
        Assert.assertEquals((Collection)formParameters.get((Object)"ComparisonOperator"), (Collection)ImmutableSet.of((Object)comparisonOperator.toString()));
        Assert.assertEquals((Collection)formParameters.get((Object)"EvaluationPeriods"), (Collection)ImmutableSet.of((Object)Integer.toString(evaluationPeriods)));
        Assert.assertEquals((Collection)formParameters.get((Object)"MetricName"), (Collection)ImmutableSet.of((Object)metricName));
        Assert.assertEquals((Collection)formParameters.get((Object)"Namespace"), (Collection)ImmutableSet.of((Object)namespace));
        Assert.assertEquals((Collection)formParameters.get((Object)"Period"), (Collection)ImmutableSet.of((Object)Integer.toString(period)));
        Assert.assertEquals((Collection)formParameters.get((Object)"Statistic"), (Collection)ImmutableSet.of((Object)statistic.toString()));
        Assert.assertEquals((Collection)formParameters.get((Object)"Threshold"), (Collection)ImmutableSet.of((Object)Double.toString(threshold)));
        Assert.assertEquals((Collection)formParameters.get((Object)"Unit"), (Collection)ImmutableSet.of((Object)unit.toString()));
    }
}

