/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.functions;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import org.jclouds.cloudwatch.CloudWatchApi;
import org.jclouds.cloudwatch.domain.AlarmHistoryItem;
import org.jclouds.cloudwatch.features.AlarmApi;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.internal.CallerArg0ToPagedIterable;

@Beta
public class ListAlarmHistoryToPagedIterable
extends CallerArg0ToPagedIterable<AlarmHistoryItem, ListAlarmHistoryToPagedIterable> {
    private final CloudWatchApi api;

    @Inject
    ListAlarmHistoryToPagedIterable(CloudWatchApi api) {
        this.api = (CloudWatchApi)Preconditions.checkNotNull((Object)api, (Object)"api");
    }

    protected Function<Object, IterableWithMarker<AlarmHistoryItem>> markerToNextForCallingArg0(final String arg0) {
        final AlarmApi alarmApi = this.api.getAlarmApiForRegion(arg0);
        return new Function<Object, IterableWithMarker<AlarmHistoryItem>>(){

            public IterableWithMarker<AlarmHistoryItem> apply(Object input) {
                return alarmApi.listHistoryAt(input.toString());
            }

            public String toString() {
                return "listHistory(" + arg0 + ")";
            }
        };
    }
}

