/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudwatch.xml;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Set;
import org.jclouds.cloudwatch.domain.Metric;
import org.jclouds.cloudwatch.xml.MetricHandler;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.IterableWithMarkers;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.util.SaxUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ListMetricsResponseHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<IterableWithMarker<Metric>> {
    private final MetricHandler metricHandler;
    private StringBuilder currentText = new StringBuilder();
    private Set<Metric> metrics = Sets.newLinkedHashSet();
    private boolean inMetrics;
    private String nextToken;

    @Inject
    public ListMetricsResponseHandler(MetricHandler metricHandler) {
        this.metricHandler = metricHandler;
    }

    public IterableWithMarker<Metric> getResult() {
        return IterableWithMarkers.from(this.metrics, (Object)this.nextToken);
    }

    public void startElement(String url, String name, String qName, Attributes attributes) throws SAXException {
        if (SaxUtils.equalsOrSuffix((String)qName, (String)"Metrics")) {
            this.inMetrics = true;
        }
        if (this.inMetrics) {
            this.metricHandler.startElement(url, name, qName, attributes);
        }
    }

    public void endElement(String uri, String name, String qName) throws SAXException {
        if (this.inMetrics) {
            if (qName.equals("Metrics")) {
                this.inMetrics = false;
            } else if (qName.equals("member") && !this.metricHandler.inDimensions()) {
                this.metrics.add(this.metricHandler.getResult());
            } else {
                this.metricHandler.endElement(uri, name, qName);
            }
        } else if (qName.equals("NextToken")) {
            this.nextToken = SaxUtils.currentOrNull((StringBuilder)this.currentText);
        }
        this.currentText = new StringBuilder();
    }

    public void characters(char[] ch, int start, int length) {
        if (this.inMetrics) {
            this.metricHandler.characters(ch, start, length);
        } else {
            this.currentText.append(ch, start, length);
        }
    }
}

