/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.binders;

import com.google.common.collect.Maps;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.File;
import java.util.Date;
import java.util.LinkedHashMap;
import org.jclouds.ec2.binders.BindBlockDeviceMappingToIndexedFormParams;
import org.jclouds.ec2.domain.Attachment;
import org.jclouds.ec2.domain.BlockDevice;
import org.jclouds.http.HttpRequest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class BindBlockDeviceMappingToIndexedFormParamsTest {
    Injector injector = Guice.createInjector((Module[])new Module[0]);
    BindBlockDeviceMappingToIndexedFormParams binder = (BindBlockDeviceMappingToIndexedFormParams)this.injector.getInstance(BindBlockDeviceMappingToIndexedFormParams.class);

    public void testMappingOrdersLexicographically() {
        LinkedHashMap mapping = Maps.newLinkedHashMap();
        mapping.put("apple", new BlockDevice("appleId", true));
        Date date = new Date(999999L);
        mapping.put("cranberry", new BlockDevice("cranberry", Attachment.Status.ATTACHED, date, false));
        HttpRequest request = HttpRequest.builder().method("POST").endpoint("http://localhost").addFormParam("InstanceId", new String[]{"i-foo"}).build();
        request = this.binder.bindToRequest(request, (Object)mapping);
        Assert.assertEquals((Object)request.getPayload().getRawContent(), (Object)"Action=ModifyInstanceAttribute&BlockDeviceMapping.1.DeviceName=apple&BlockDeviceMapping.1.Ebs.DeleteOnTermination=true&BlockDeviceMapping.1.Ebs.VolumeId=appleId&BlockDeviceMapping.2.DeviceName=cranberry&BlockDeviceMapping.2.Ebs.DeleteOnTermination=false&BlockDeviceMapping.2.Ebs.VolumeId=cranberry&InstanceId=i-foo");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testMustBeBlockDeviceMapping() {
        HttpRequest request = HttpRequest.builder().method("POST").endpoint("http://localhost").build();
        this.binder.bindToRequest(request, (Object)new File("foo"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testNullIsBad() {
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://momma").build();
        this.binder.bindToRequest(request, null);
    }
}

