/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.binders;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import org.jclouds.ec2.binders.BindTagKeysToIndexedFormParams;
import org.jclouds.http.HttpRequest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class BindTagKeysToIndexedFormParamsTest {
    BindTagKeysToIndexedFormParams binder = new BindTagKeysToIndexedFormParams();

    public void test() {
        HttpRequest request = HttpRequest.builder().method("POST").endpoint("http://localhost").build();
        request = this.binder.bindToRequest(request, (Object)ImmutableSet.of((Object)"one", (Object)"two"));
        Assert.assertEquals((Object)request.getPayload().getRawContent(), (Object)"Tag.1.Key=one&Tag.2.Key=two");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testMustBeIterable() {
        HttpRequest request = HttpRequest.builder().method("POST").endpoint("http://localhost").build();
        this.binder.bindToRequest(request, (Object)new File("foo"));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void testNullIsBad() {
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://momma").build();
        this.binder.bindToRequest(request, null);
    }
}

